/* 
 * This File is part of the iowj-project  
 * $Id$
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import sun.misc.Queue;
import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD16x16Pio;

/**
 * This test shows the lcd usage with two threads.
 * Minimal LCD2x16 is requested.
 */
public class ThreadTest {

	static Queue q = new Queue();


	public void doIt() {
		
		try {
		
		IowFactory devs = IowFactory.getInstance();
		AbstractIowDevice iow = devs.getIowDevice();
		
		AbstractLCD lcd = new LCD16x16Pio(iow);
				
		//LCD lcd = new LCD2x16();
		//iow.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
		
		//lcd.setDisplayControl(true, false, false);
		lcd.check();
		
		
		FirstThread wt = new FirstThread(lcd);
		SecondThread rt = new SecondThread(lcd);
		wt.start();
		rt.start();
		
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		
	}

	public static void main(String[] args) {
		ThreadTest t = new ThreadTest();
		t.doIt();
	}
	
	
	class FirstThread extends Thread {
		AbstractLCD q;
		int i = 0;
		
		public FirstThread(AbstractLCD q){
			this.q = q; 
		}
		
		public void run() {
			System.out.println("Starting FirstThread ...");
			while(true){
				q.writeLine(1,true,"1stThread:"+i++);
				try {
					Thread.sleep(100);
				}
				catch (InterruptedException e) {
								
				}
			}
		}
	}

	class SecondThread extends Thread {
		AbstractLCD q;
		int i = 0;
			
		public SecondThread(AbstractLCD q){
			this.q = q; 
		}
		
		public void run() {
			System.out.println("Starting SecondThread ...");
			while(true){
				try {
					q.writeLine(2,true,"2ndThread:"+i++);
					Thread.sleep(200);
				}
				catch (InterruptedException e) {
								
				}
			}
		}
	}	
	
}
