/*
 * Created on 27.02.2006
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package de.wagner_ibw.test;

import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowChangeListener;
import de.wagner_ibw.iow.IowFactory;


/**
 * @author Thomas Wagner
 *
 */
public class SimpleIoTest implements IowChangeListener{

	private IowFactory   devs;
	private AbstractIowDevice dev40 = null;
		
	/**
 	* Constructor for stand-alone operation.
 	*/
	public  SimpleIoTest() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any plugged IOW device!");
			devs.exit(-1);
		} 
	}
		
	/**
	 * Constructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
	public SimpleIoTest(IowFactory devs) {
		this.devs = devs;
	}

	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */	
	public static void main(String[] args) {
		SimpleIoTest iot = new SimpleIoTest();
		iot.doit();
		iot.devs.exit(0);	//never reached
	} 
	
	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}
	
	/**
	 * Do all that work.
	 */
	private void doit() {
		int pause = 200;
			
		try {
			dev40 = devs.getIowDevice();


			dev40.writeIOPorts();
			Thread.sleep(pause);
	
			dev40.writeIOPorts(0xff0000ff);
			Thread.sleep(pause);
			dev40.writeIOPorts(0x00000000);
			Thread.sleep(pause);
			dev40.writeIOPorts(0xff0000ff);
			Thread.sleep(pause);
			dev40.writeIOPorts(0x00000000);
			Thread.sleep(pause);
			dev40.writeIOPorts(0xff0000ff);
			Thread.sleep(pause);
			dev40.writeIOPorts(0x00000000);
			Thread.sleep(pause);
			dev40.writeIOPorts(0xff0000ff);
			Thread.sleep(pause);
			dev40.writeIOPorts(0x00000000);
			Thread.sleep(pause);
				
			dev40.writeIOPorts(0xff0000ff); //all leds off
			Thread.sleep(pause);
	
			dev40.writeIOPorts(0xbf);
				
			dev40.autonomous(true);			
			System.out.println(dev40);
			dev40.addIowChangeListener(this);
			System.out.println(dev40);
				
			//while(true) { //endless loop
				Thread.sleep(20000);
			//}
			devs.exit(0);
				
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
		

	/* (non-Javadoc)
	 * @see de.wagner_ibw.iow.IowChangeListener#iowChanged(long)
	 */
	public void iowChanged(long value) {
		/*deb*/System.out.println("iowChanged:" + Long.toHexString(value));
	}

}
