package de.wagner_ibw.test;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.IowPort;
import de.wagner_ibw.iow.IowPortChangeListener;

public class ReadPerformanceTest implements IowPortChangeListener{
		
	/*
	 * Port Changed Callback
	 * @see de.wagner_ibw.iow.IowPortChangeListener#portChanged(de.wagner_ibw.iow.IowPort)
	 */
	public synchronized void  portChanged(IowPort port) {
		int p = (port.getData() & 0xf0) >> 4;
		if (p == 0) System.out.println();
		System.out.print(p + " ");
	}
	
	public static void main(String[] args) {
		Iow40   dev40  = null;
				
		ReadPerformanceTest iit = new ReadPerformanceTest();	
		IowFactory devs = IowFactory.getInstance();
		
		try {
			dev40 = devs.getIow40Device();
			dev40.autonomous(true);			
			dev40.getPort(2).addPortChangeListener(iit);
		}
		catch(Exception e) {
			System.exit(1);
		}
	}
}

