/* 
 * This File is part of the iowj-project  
 * $Id: Rc5Test.java,v 1.1.1.1 2006/01/15 16:47:29 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.IowPort;
import de.wagner_ibw.iow.IowPortChangeListener;
import de.wagner_ibw.iow.SpecialModeFunction;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD2x40;
import de.wagner_ibw.iow.rc5.RC5;
import de.wagner_ibw.iow.rc5.RC5Event;
import de.wagner_ibw.iow.rc5.RC5KeyChangeListener;

/**
 * This simple test prog checks the class RC5 and shows the scanned RC5 codes
 * on the display. The output should like this (depends on your pressed key ;-)
 * <pre>
 * Code Addr  Toogle C6
 * 8    5     false  true
 * </pre>
 * If you do not have any display, set LCD = false.
 * @author Thomas Wagner
 * @since 0.9.2
 */ 
public class Rc5Test implements IowPortChangeListener,RC5KeyChangeListener {
	
	final static boolean LCD = false;
	final static boolean DEBUG = false;
	static Iow24 dev24; 
	static AbstractLCD lcd;
	
	public static void main(String[] args) {
		Rc5Test rc5t = new Rc5Test();
		rc5t.doIt();
	}
	
	public void doIt() { 
		try {
			RC5 rc5;
			IowFactory devs  = IowFactory.getInstance();
						
			dev24 = devs.getIow24Device();
			System.out.println(dev24);
			if (LCD) {
				lcd = new LCD2x40();
				dev24.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
				System.out.println(dev24);
			}
						
			if (LCD) {
				//Turn on display, cursor off and blinking off
				lcd.setDisplayControl(true, false, false);
	
				//show greetings
				lcd.writeLine(1,2,false, "Test RC5");
				Thread.sleep(2000);
			}
			
			rc5 = new RC5();
			dev24.addSpecialModeFunctionImpl(rc5);
			System.out.println(rc5);
			rc5.addKeyChangeListener(this);
			System.out.println(rc5);
			
			IowPort p0 = dev24.getPort(0);
			dev24.autonomous(true);
			p0.addPortChangeListener(this);
			
			
			System.out.println(dev24);	
			if (LCD)
				lcd.writeLine(1,true, "Code Addr Toggle C6");
		
			
			Thread.sleep(200000);
			if (LCD)
				lcd.writeLine(2,true, "Stop Receiving RC5 Commands");
		
			p0.removePortChangeListener(this);
			dev24.autonomous(false);

			rc5.removeKeyChangeListener(this);			
			dev24.removeSpecialModeFunctionImpl(rc5);		
			System.out.println(dev24);

			
			/*
			System.out.println(dev24.getPort(0).toString());
			dev24.getPort(0).setDirection("IIIIOOOO");
			System.out.println(dev24.getPort(0).toString());
			
			//Led on
			if (LCD) {
				lcd.writeLine(2,true, "Led on ...");
			}
			dev24.setPort(0,0);
			System.out.println(dev24.getPort(0).toString());
			dev24.writeIOPorts();
			
			Thread.sleep(2000);
			
			//Led off
			if (LCD) {
				lcd.writeLine(2,true, "Led off ...");
			}
			dev24.setPort(0,0xff);
			System.out.println(dev24.getPort(0).toString());
			dev24.writeIOPorts();
			*/
			if (LCD) {
				Thread.sleep(2000);
				//clear the display
				lcd.clearLCD();
				//lcd.check();
				lcd.writeLine(lcd.getRows(),5,true, "The End");
				dev24.removeSpecialModeFunctionImpl((SpecialModeFunction)lcd);
				System.out.println(dev24);
			}
		}
		catch(Exception e) {
			e.printStackTrace();
			System.exit(1);	
		}
		System.exit(0);
	}
	/* (non-Javadoc)
	 * @see de.wagner_ibw.iow.IowPortChangeListener#portChanged(de.wagner_ibw.iow.IowPort)
	 */
	public synchronized void portChanged(IowPort port) {
		System.out.println(port.toString());
	}

	/* (non-Javadoc)
	 * @see de.wagner_ibw.iow.RC5KeytChangeListener#keyChanged(de.wagner_ibw.iow.RC5Code)
	 */
	public synchronized void keyChanged(RC5Event event) {
		System.out.println(event);
		//lcd.writeLine(1,true, "Code Addr Toggle C6");
		
		if (LCD) {
			lcd.writeLine(2,true, "" + event.getCode());
			lcd.setCursor(2,6);
			lcd.writeString( "" + event.getAddress());
			lcd.setCursor(2,11);
			lcd.writeString( "" + event.getToggleBit());
			lcd.setCursor(2,18);
			lcd.writeString( "" + event.getC6CommandBit());
		}
	}

}
