/*
 * This File is part of the iowj-project   
 * $Id: PCF8591Test.java,v 1.2 2007/03/04 17:47:34 Thomas Wagner Exp $
 * Copyright (C)2007 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.i2c.I2C;
import de.wagner_ibw.iow.i2c.PCF8591;


/**
 * It is a simple test program for I2C and PCF8591.
 * @author Thomas Wagner
 */
public class PCF8591Test implements Runnable {
	
	private IowFactory   devs;
	private AbstractIowDevice dev;
		
	/**
	 * Constructor for stand-alone operation.
	 */
	public PCF8591Test() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
	}
	
	/**
	 * Contructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
//	public PCF8591Test(IowFactory devs) {
//		this.devs = devs;
//	}
	
	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */
	public static void main(String[] args) {
		PCF8591Test pcf = new PCF8591Test();
		pcf.doit();
		pcf.devs.exit(0);
	}

	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}
	
	
	/**
	 * Do all that work.
	 */
	private void doit() {
			
		PCF8591 pc = null;
					
		try{
			dev = devs.getIowDevice();
						 
			I2C i2c = new I2C();
			try { 
				dev.addSpecialModeFunctionImpl(i2c);
			} catch (IllegalArgumentException i) {
				i2c = (I2C) dev.getSpecialModeFunctionImpl("I2C");
			}
			 
			pc = new PCF8591(0x0);
			
			i2c.addI2CDevice(pc);
			System.out.println("----- PCF8591Test -----\n"+dev);
			//System.out.println(pc);
			
			//pc.setAnalogueInputProgramming(4);
			pc.setAnalogueInputProgramming(PCF8591.INPUT_MODE_1);
			//pc.setAnalogueInputProgramming(PCF8591.INPUT_MODE_2);
			//pc.setAnalogueInputProgramming(PCF8591.INPUT_MODE_3);
			
			pc.enableAnalogueOutput();
			pc.setAnalogueOutputValue(0xc0);
			
			/* Einzelkanal test
			int channel = 0;
			for(int i = 0; i < 4; i++) {
				System.out.println(i + " Channel "+channel+": " + Integer.toHexString(pc.getChannel(channel)));
				Thread.sleep(500);
			}
			System.out.println();
			channel = 1;
			for(int i = 0; i < 4; i++) {
				System.out.println(i + " Channel "+channel+": " + Integer.toHexString(pc.getChannel(channel)));
				Thread.sleep(500);
			}
			channel = 2;
			System.out.println();
			for(int i = 0; i < 4; i++) {
				System.out.println(i + " Channel "+channel+": " + Integer.toHexString(pc.getChannel(channel)));
				Thread.sleep(500);
			}
			channel = 3;
			System.out.println();
			for(int i = 0; i < 4; i++) {
				System.out.println(i + " Channel "+channel+": " + Integer.toHexString(pc.getChannel(channel)));
				Thread.sleep(500);
			}
			*/
			//* Autoinkrement test
			int data[] = pc.getChannels();
			for ( int i = 0; i < 4; i++) {
				System.out.println("Channel "+i+": " + Integer.toHexString(data[i]));
			}
			
			Thread.sleep(500);
			System.out.println();
			data = pc.getChannels();
			for ( int i = 0; i < 4; i++) {
				System.out.println("Channel "+i+": " + Integer.toHexString(data[i]));
			}
			
			Thread.sleep(500);
			System.out.println();			
			data = pc.getChannels();
			for ( int i = 0; i < 4; i++) {
				System.out.println("Channel "+i+": " + Integer.toHexString(data[i]));
			}
			//*/
			Thread.sleep(500);
			int channel = 1;
			System.out.println("\nsingle channel mode");
			System.out.println("Channel "+channel+": " + Integer.toHexString(pc.getChannel(channel)));		
			System.out.println("------ "+this.getClass().getName()+" ende------");
			
			Thread.sleep(500);
			System.out.println("\nmulti channel mode");			
			data = pc.getChannels();
			for ( int i = 0; i < 4; i++) {
				System.out.println("Channel "+i+": " + Integer.toHexString(data[i]));
			}
			
			Thread.sleep(500);
			System.out.println("\nsingle channel mode");	
			for(int i = 0; i < 4; i++) {
				System.out.println(i + " Channel "+i+": " + Integer.toHexString(pc.getChannel(i)));
				Thread.sleep(500);
			}
		}
		catch(Exception e ){
			e.printStackTrace();
		}
	}
}
