package de.wagner_ibw.test;

import java.util.NoSuchElementException;

import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.Iow56;
import de.wagner_ibw.iow.IowFactory;

public class MacTest24 {

	static boolean IOW24 = true;
	static boolean IOW40 = true;
	static boolean IOW56 = true;

	private IowFactory   devs;
	private Iow24 dev24 = null;
	private Iow40 dev40 = null;
	private Iow56 dev56 = null;
		
	/**
	 * Constructor for stand-alone operation.
	 */
	public  MacTest24() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		MacTest24 iot = new MacTest24();
		iot.doit();
		iot.devs.exit(0);	//never reached

	}

	/**
	 * Do all that work.
	 */
	private void doit() {
		int pause = 200;
		
		try {
			dev24 = devs.getIow24Device();
		} catch (NoSuchElementException e) {
			IOW24 = false;
		}
		try {	
			dev40 = devs.getIow40Device();
		} catch (NoSuchElementException e) {
			IOW40 = false;
		}
		try {	
			dev56 = devs.getIow56Device();
		} catch (NoSuchElementException e) {
			IOW56 = false;
	    }
		
		try {
			//dev24.setWriteTimeout(1000);
			if(IOW24) dev24.setDirection(0, 0xf7); //all bits input, except bit 3 is output
			if(IOW40) dev40.setDirection(3, 0x00); 
			if(IOW56) dev56.setDirection(6, 0x7f); //all bits input, except bit 7 is output
			
			if(IOW24) System.out.println(dev24);
			if(IOW40) System.out.println(dev40);
			if(IOW56) System.out.println(dev56);
			
			if(IOW24) dev24.setPort(0, 0xff);	//all leds on
			if(IOW40) dev40.setPort(3, 0xff);
			if(IOW56) dev56.setPort(6, 0xff);
			if(IOW24) dev24.writeIOPorts();
			if(IOW56) dev56.writeIOPorts();
			if(IOW40) dev40.writeIOPorts();
		
			Thread.sleep(pause);
			
			if(IOW24) dev24.setPort(0, 0x00);
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0x00);
			if(IOW40) dev40.writeIOPorts();
			if(IOW56) dev56.setPort(6, 0x00);
			if(IOW56) dev56.writeIOPorts();
			Thread.sleep(pause);
	
			if(IOW24) dev24.setPort(0, 0xff);
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0xff);
			if(IOW40) dev40.writeIOPorts();
			if(IOW56) dev56.setPort(6, 0xff);
			if(IOW56) dev56.writeIOPorts();
			
			Thread.sleep(pause);
			
			if(IOW24) dev24.setPort(0, 0x00);
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0x00);
			if(IOW40) dev40.writeIOPorts();
			if(IOW56) dev56.setPort(6, 0x00);
			if(IOW56) dev56.writeIOPorts();
			Thread.sleep(pause);
			
			if(IOW24) dev24.setPort(0, 0xff);
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0xff);
			if(IOW40) dev40.writeIOPorts();
			if(IOW56) dev56.setPort(6, 0xff);
			if(IOW56) dev56.writeIOPorts();
			Thread.sleep(pause);
			
			if(IOW24) dev24.setPort(0, 0x00);
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0x00);
			if(IOW56) dev56.setPort(6, 0x00);
			if(IOW56) dev56.writeIOPorts();
			if(IOW40) dev40.writeIOPorts();
			
			Thread.sleep(pause);
			
			if(IOW24) dev24.setPort(0, 0xff);
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0xff);
			if(IOW40) dev40.writeIOPorts();
			if(IOW56) dev56.setPort(6, 0xff);
			if(IOW56) dev56.writeIOPorts();
			Thread.sleep(pause);
			
			if(IOW24) dev24.setPort(0, 0x00);
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0x00);
			if(IOW40) dev40.writeIOPorts();
			if(IOW56) dev56.setPort(6, 0x00);
			if(IOW56) dev56.writeIOPorts();
			Thread.sleep(pause);
			
			if(IOW24) dev24.setPort(0, 0xff);
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0xff);
			if(IOW40) dev40.writeIOPorts();
			if(IOW56) dev56.setPort(6, 0xff);
			if(IOW56) dev56.writeIOPorts();
			Thread.sleep(pause);
			
			if(IOW24) dev24.setPort(0, 0x00);
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0x00);
			if(IOW40) dev40.writeIOPorts();
			if(IOW56) dev56.setPort(6, 0x00);
			if(IOW56) dev56.writeIOPorts();
			Thread.sleep(pause);
			
			if(IOW24) dev24.setPort(0, 0xff); //all leds off
			if(IOW24) dev24.writeIOPorts();
			if(IOW40) dev40.setPort(3, 0xff);
			if(IOW40) dev40.writeIOPorts();
			if(IOW56) dev56.setPort(6, 0xff);
			if(IOW56) dev56.writeIOPorts();
			Thread.sleep(pause);

			if(IOW24) dev24.setPort(0, 0xbf);
			if(IOW24) dev24.writeIOPorts();
			//System.out.println("OUT portChanged (index:0)," + dev24.getPort(0));

			
			
			if(IOW40) dev40.readIOPortsNonBlocking();
			//if(IOW40) dev40.readIOPortsImmediate();
			if(IOW40) System.out.println("IOW40: "+ dev40.getPort(0));
			
			if(IOW56) dev56.readIOPortsNonBlocking();
			if(IOW56) System.out.println("IOW56: "+ dev56.getPort(6));
			
			if(IOW24) dev24.readIOPortsNonBlocking();
			if(IOW24) System.out.println("IOW24: "+ dev24.getPort(0));
			
			//while(true) { //endless loop
				//Thread.sleep(20000);
			//}
			devs.exit(0);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	
	
}
