/*
 * This File is part of the iowj-project   
 * $Id: M95020Test.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * Copyright (C)2004 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.spi.M95020;
import de.wagner_ibw.iow.spi.SPI;

/**
 * It is a simple test program for the M95020 spi device.
 * This test now works with IO-Warrior 24 and IO-Warrior 56.
 * @author Thomas Wagner
 */
public class M95020Test implements Runnable {
	
	
	private IowFactory   devs;
	private AbstractIowDevice dev;
	private SPI spi;
		
	/**
	 * Constructor for stand-alone operation.
	 */
	public M95020Test() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
	}
	
	/**
	 * Contructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
	public M95020Test(IowFactory devs) {
		this.devs = devs;
	}
	
	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */
	public static void main(String[] args) {
		M95020Test st = new M95020Test();
		st.doit();
		st.devs.exit(0);
	}

	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}
	
	
	/**
	 * Do all that work.
	 */
	private void doit() {
							
		try{
			dev = devs.getIowDevice();
			
			if (dev.getId() == AbstractIowDevice.IOW24ID) {	
				System.out.println("Using IO-Warrior 24 ...");	
				spi = new SPI(0x02); 		//IO-Worrier 24
			} else if (dev.getId() == AbstractIowDevice.IOW56ID) {
				System.out.println("Using IO-Warrior 56 ...");							 
				spi = new SPI(0x00,255);	//IO-Warrier 56, 0x0fCPOL=CPHA=1 and 1MBit/sec  
			} else {
				System.out.println("Using IO-Warrior 40 ... not possible!");
				devs.exit(0);
			}
				
			dev.addSpecialModeFunctionImpl(spi);
						 
			M95020 m = new M95020();
			
			spi.setSPIDevice(m);
			
			System.out.println(m);
			System.out.println(dev.toString());
			
	
//			System.out.println("writeEnable...");
//			m.writeEnable();
//			m.readStatusReg();
//			System.out.println(m.toString());
	//*		
			System.out.println("Read 0 : "+ m.read(0));
			System.out.println("Read 1 : "+ m.read(1));
			System.out.println("Read 2 : "+ m.read(2));
			System.out.println("Read 3 : "+ m.read(3));
			
					
			m.write(0,'H');
			m.write(1,'a');
			m.write(2,'u');
			m.write(3,'s');
						
			System.out.println("Read 0 : "+ (char)m.read(0));
			System.out.println("Read 1 : "+ (char)m.read(1));
			System.out.println("Read 2 : "+ (char)m.read(2));
			System.out.println("Read 3 : "+ (char)m.read(3));
			
			System.out.println("Read 0 : "+ (char)m.read(0));
			System.out.println("Read 1 : "+ (char)m.read(1));
			System.out.println("Read 2 : "+ (char)m.read(2));
			System.out.println("Read 3 : "+ (char)m.read(3));
	//*/	
	
			m.fillEeprom('?');
	
			int b[] = {'O','t','t','o',' ','M','u','e','l','l','e','r','3','4','5','6'};
			m.writePage(0,b);
			int r[] = m.readPage(0,b.length);
					
			for(int i = 0; i < r.length; i++) {
				System.out.print((char)r[i]);
			}
			System.out.println();
			
			r = m.readPage(0,256);
					
			for(int i = 0; i < r.length; i++) {
				System.out.print((char)r[i]);
				//System.out.println(i + "\t" +(char)r[i]);
			}
			System.out.println();
			
			
			m.fillEeprom('+');
			r = m.readPage(0,256);
					
			for(int i = 0; i < r.length; i++) {
				System.out.print((char)r[i]);
				//System.out.println(i + "\t" +(char)r[i]);
			}
			System.out.println();
			
			devs.exit(0);
		}
		catch(Exception e ){
			e.printStackTrace();
		}
	}
}
