/*
 * Created on 27.02.2006
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package de.wagner_ibw.test;

import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.lcd.M50530Pio;


/**
 * @author Thomas Wagner
 *
 */
public class M50530Test {

	private IowFactory   devs;
	private AbstractIowDevice dev40 = null;
		
	/**
 	* Constructor for stand-alone operation.
 	*/
	public  M50530Test() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any plugged IOW device!");
			devs.exit(-1);
		} 
	}
		
	/**
	 * Constructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
	public M50530Test(IowFactory devs) {
		this.devs = devs;
	}

	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */	
	public static void main(String[] args) {
		M50530Test iot = new M50530Test();
		iot.doit();
		iot.devs.exit(0);	//never reached
	} 
	
	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}
	
	/**
	 * Do all that work.
	 */
	private void doit() {
		int pause = 200;
			
		try {
			dev40 = devs.getIowDevice();
			M50530Pio lcd = new M50530Pio(dev40);
			
			Thread.sleep(1000);
			
			lcd.check();
			Thread.sleep(1000);
			lcd.writeLine(8,true," [F1][F2][F3][F4][5][6]");
			Thread.sleep(1000);
			
			lcd.clearLCD();
			
			int c = 0;
			for (int i = 0; i < 8; i++) {
				lcd.setCursor(i+1,1);
				for (int j = 0; j < 16; j++) {	
					lcd.writeCharInc(c);
					c++;
				}
			}
			Thread.sleep(5000);
			for (int i = 0; i < 8; i++) {
				lcd.setCursor(i+1,1);
				for (int j = 0; j < 16; j++) {	
					lcd.writeCharInc(c);
					c++;
				}
			}
			
			
//			for(int j = 0; j < 16; j ++)
//				for(int i = 0; i < 16; i++) {
//					lcd.writeCharInc(c);
//					c++;
//				}
//			}
			
//			lcd.writeCharInc('T');
//			lcd.writeCharInc('e');
//			lcd.writeCharInc('s');
//			lcd.writeCharInc('t');
			
			
//			//Make sure Pin0.1 is low
//			dev40.setDirection(0,0xfd); //bit 1 output
//			dev40.clearBit(0,1);
//			dev40.writeIOPorts();
//
//
//			//enable LCD special mode function
//			System.out.println("init LCD specal mode function");
//			int wbuf[] = {4, 1, 0, 0, 0, 0, 0, 0};
//			long ret = dev40.writeReport(1,wbuf);
//			System.out.println("init LCD returns: " + ret);
//
//
////			dev40.setBit(0,1);
////			dev40.writeIOPorts();
//
//			int wbuf1[] = {5, 0x06,0x23, 0xe0, 0x40, 0x0d, 0x05, 0x01};
//			ret = dev40.writeReport(1,wbuf1);
//			System.out.println("writeReport returns: " + ret);
//
//
//
////			//             id    len
////			int wbuf1[] = {5, 0x06,0xFA, 0x50, 0x0C, 0x05, 0x01, 0x31};
////			dev40.writeReport(1,wbuf1);
////			System.out.println("writeReport returns: " + ret);
////			//                  rs len
////			int wbuf2[] = {5, 0x86, 73, 79, 87 , 97, 114, 114};
////			dev40.writeReport(1,wbuf2);	
////			System.out.println("writeReport returns: " + ret);		   
////			//                  rs len
////			int wbuf3[] = {5, 0x85, 105,  111,  114, 50, 52, 0};	   
////			dev40.writeReport(1,wbuf3);	
////			System.out.println("writeReport returns: " + ret);		   
//

			
				
			//while(true) { //endless loop
				Thread.sleep(20);
			//}
			devs.exit(0);
				
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
