/* 
 * This File is part of the iowj-project  
 * $Id: Led24Test.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * Copyright (C)2004 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.Iow56;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.IowPort;
import de.wagner_ibw.iow.IowPortChangeListener;
import de.wagner_ibw.iow.SpecialModeFunction;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD2x40;
import de.wagner_ibw.iow.lcd.LCD4x16;

/**
 * @author Thomas Wagner
 */ 
public class Led56Test implements IowPortChangeListener {
	
	final static boolean CHECK_24 = false;
	final static boolean CHECK_40 = false;
	final static boolean CHECK_56 = true;
	final static boolean LISTENER_56 = false;
	final static boolean LCD = false;
	final static boolean DEBUG = false;
	static Iow24 dev24; 
	static Iow40 dev40;
	static Iow56 dev56;
	
	public static void main(String[] args)  {
	
		try {
			AbstractLCD lcd;
			IowFactory devs  = IowFactory.getInstance();
						
			if(CHECK_24) {
				dev24 = devs.getIow24Device();
				System.out.println(dev24.toString());
				if (LCD) {
					lcd   = new LCD2x40();
					dev24.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
				}
			}
			else if(CHECK_40) {
				dev40 = devs.getIow40Device();
				System.out.println(dev40.toString());
				if (LCD) {
					lcd   = new LCD4x16();
					//dev40.addSpecialModeFunctionImpl(lcd);
				}
			}
			
			else if(CHECK_56) {
				dev56 = devs.getIow56Device();
				System.out.println(dev56.toString());
				if (LCD) {
					lcd   = new LCD4x16();
					//dev40.addSpecialModeFunctionImpl(lcd);
				}
			}
			
			if (LCD) {
				//Turn on display, cursor off and blinking off
				lcd.setDisplayControl(true, false, false);
	
				//show greetings
				lcd.writeLine(1,2,false, "Test LED");
				Thread.sleep(2000);
			}
			
			if(CHECK_24) {
				System.out.println("Check IOW24 ...");
/*---------------------------------------------------------------------------			
				int[] buf = dev24.getCurrentPinStatus();
				if(buf != null) {
					/+for (int i = 0; i < buf.length; i++) {
						System.out.println("Byte "+i+": "+ buf[i]);
					}+/
					System.out.println("Port0: "+ buf[1]);
					System.out.println("Port1: "+ buf[2]);
				}
				else {
					System.out.println("Buffer is null");
				}
-----------------------------------------------------------------------------*/
				System.out.println(dev24.getPort(0).toString());
				dev24.getPort(0).setDirection("IIIIOOOO");
				System.out.println(dev24.getPort(0).toString());
			
				//Led on
				if (LCD) {
					lcd.writeLine(2,true, "Led on ...");
				}
				dev24.setPort(0,0);
				System.out.println(dev24.getPort(0).toString());
				dev24.writeIOPorts();
				
				Thread.sleep(2000);
			
				//Led off
				if (LCD) {
					lcd.writeLine(2,true, "Led off ...");
				}
				dev24.setPort(0,0xff);
				System.out.println(dev24.getPort(0).toString());
				dev24.writeIOPorts();
			
				if (LCD) {
					Thread.sleep(2000);
					//clear the display
					lcd.clearLCD();
					//lcd.check();
					lcd.writeLine(lcd.getRows(),5,true, "The End");
				}
			}
			else if (CHECK_40) {
				System.out.println("Check IOW40 ...");
				int[] buf = null;//dev40.getCurrentPinStatus();
				if(buf != null) {
					/*for (int i = 0; i < buf.length; i++) {
						System.out.println("Byte "+i+": "+ buf[i]);
					}*/
					System.out.println("Port0: "+ buf[1]);
					System.out.println("Port1: "+ buf[2]);
					System.out.println("Port2: "+ buf[3]);
					System.out.println("Port3: "+ buf[4]);
				}
				else {
					System.out.println("Buffer is null");
				}
				System.out.println("Check IOW40 P0...");
				System.out.println(dev40.getPort(3).toString());
				dev40.getPort(3).setDirection("OOOOOOOO");
				System.out.println(dev40.getPort(3).toString());
			
				System.out.println("Check IOW40 P1...");
				
				//Led on
				if (LCD) {
					lcd.writeLine(2,true, "Led on ...");
				}
				dev40.setPort(3,0);
				System.out.println(dev40.getPort(3).toString());
				dev40.writeIOPorts();
				
				Thread.sleep(2000);
			
				//Led off
				if (LCD) {
					lcd.writeLine(2,true, "Led off ...");
				}
				dev40.setPort(3,0xff);
				System.out.println(dev40.getPort(3).toString());
				dev40.writeIOPorts();
			
				if (LCD) {
					Thread.sleep(2000);
					//clear the display
					lcd.clearLCD();
					//lcd.check();
					lcd.writeLine(lcd.getRows(),5,true, "The End");
				}
			}
			else if (CHECK_56) {
				System.out.println("Check IOW56 ...");
				
				if(LISTENER_56) {
					dev56.autonomous(true);			
					dev56.getPort(6).addPortChangeListener(new Led56Test());
				}			
/*---------------------------------------------------------------------------
				int[] buf = dev56.getCurrentPinStatus();
				if(buf != null) {
					/+for (int i = 0; i < buf.length; i++) {
						System.out.println("Byte "+i+": "+ buf[i]);
					}+/
					System.out.println("Port0: "+ buf[1]);
					System.out.println("Port1: "+ buf[2]);
					System.out.println("Port2: "+ buf[3]);
					System.out.println("Port3: "+ buf[4]);
					System.out.println("Port4: "+ buf[4]);
					System.out.println("Port5: "+ buf[4]);
				}
				else {
					System.out.println("Buffer is null");
				}
-----------------------------------------------------------------------------*/
				
				dev56.setDirection(6,0);
				
				for(int i=0; i < 8; i++) {
					if((i%2)!=0)
						dev56.setPort(6,0x00);
					else
						dev56.setPort(6,0xff);				
					
					System.out.println(dev56);
					dev56.writeIOPorts();
					Thread.sleep(400);
					
				}
				
				
				
				
				
				//dev56.readIOPortsImmediate();
				dev56.readIOPorts();
				System.out.println(dev56.toString());				
				
				
				
				
//				//System.out.println(dev56.getPort(0).toString());
//				//System.out.println("Check IOW56 P6.0...");
//				//System.out.println(dev56.getPort(5).toString());
//				dev56.getPort(6).setDirection("OOOOOOOI");
//				System.out.println("initial: " + dev56.getPort(6).toString());
//				
//				//System.out.println("Check IOW56 P6.7...");
//				
//				//Led on
//				if (LCD) {
//					lcd.writeLine(2,true, "Led on ...");
//				}
//				dev56.setPort(6,0);
//				System.out.println("after n: " + dev56.getPort(6).toString());
//				dev56.writeIOPorts();
//				
//				Thread.sleep(1000);
//			
//				//Led off
//				if (LCD) {
//					lcd.writeLine(2,true, "Led off ...");
//				}
//				dev56.setPort(6,0xff);
//				System.out.println("after f: " + dev56.getPort(6).toString());
//				dev56.writeIOPorts();
//			
//				if (LCD) {
//					Thread.sleep(2000);
//					//clear the display
//					lcd.clearLCD();
//					//lcd.check();
//					lcd.writeLine(lcd.getRows(),5,true, "The End");
//				}

			}									
		}
		catch(Exception e) {
			e.printStackTrace();
			System.exit(1);	
		}
		if(!LISTENER_56) System.exit(0);
	}
	
	public synchronized void  portChanged(IowPort port) {
		System.out.println("portChanged (index:"+port.getIndex()+")," + port.toString());
		
		if(port.getIndex() == 5) {
			if(port.isBitClear(0)) { 
				System.out.println("P5.0 is clear");
			}
			else {
				System.out.println("P5.0 is set");
			}
		}
	}
}
