/*
 * This File is part of the iowj-project   
 * $Id: LM75OSTest.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * Copyright (C)2004 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.SpecialModeFunction;
import de.wagner_ibw.iow.i2c.I2C;
import de.wagner_ibw.iow.i2c.LM75;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD4x16;

/**
 * It is a simple test program for I2C and LM75.
 * 
 * @author Thomas Wagner
 *
 */
public class LM75OSTest {
	
	static boolean DEBUG = false;
	static boolean LOOP = false;
	static boolean SHOW = true;

	static IowFactory   devs;
	static Iow40 dev40;
	
	public static void main(String[] args) {
	
		AbstractLCD lcd = null;
		LM75 lm = null;
		IowFactory devs = IowFactory.getInstance();
				
		try{
			dev40 = devs.getIow40Device();
			dev40.setTimeout(1000);
				
			dev40.getPort(0).setDirection("OOOOOOII"); //Taster, LM75
			dev40.getPort(3).setDirection("OOOOOOOO"); //Led
			 
			I2C i2c = new I2C();  
			dev40.addSpecialModeFunctionImpl(i2c);
			
			 
			lm = new LM75(0x0);
			
			i2c.addI2CDevice(lm);
			
			System.out.println(lm);
			
			
			if(SHOW){
				lcd = new LCD4x16();
				dev40.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
				
				
				//Turn on display, cursor and blinking
				lcd.setDisplayControl(true, false, false);
				//Set cursor movement to right and no shifting
				lcd.setEntryMode(true, false);
				
				lcd.writeLine(1,true,"IOW40 LM75 Demo");
//				Thread.sleep(2000);
			}
			
							
			System.out.println(dev40.toString());
				
					
//			lm.getConfiguration();
			lm.setConfiguration(LM75.MODE_COMPARATOR,LM75.POLARITY_ACTIVE_HIGH);
			lm.getConfiguration();
//			lm.setConfiguration(LM75.MODE_COMPARATOR,LM75.POLARITY_ACTIVE_HIGH);
//			lm.getConfiguration();
//			lm.setConfiguration(LM75.MODE_INTERRUPT,LM75.POLARITY_ACTIVE_LOW);
//			lm.getConfiguration();
//			lm.setConfiguration(LM75.MODE_INTERRUPT,LM75.POLARITY_ACTIVE_HIGH);
//			lm.getConfiguration();
										
			System.out.println("Temperature: "+lm.getT());
									
			lm.setTOs(27.0);
			lm.setTHyst(25.0);
			System.out.println(lm);
					
								
			for(int i = 0; i < 40; i++){
				double temp = lm.getT();					
				System.out.print("Temperature: "+temp+"   ");
				//dev40.readIOPorts();
				dev40.readIOPortsImmediate();
				//System.out.println("\t"+dev40.ports[0]);
				
				if(SHOW) {
					//lcd.setCursorHome();
					//lcd.setCursor(1,0);
					lcd.writeLine(2,false,"Temp: "+temp);
					
					//lcd.setCursor(1,11);
					dev40.readIOPortsImmediate();
					if(dev40.getPort(0).isBitSet(1))
						lcd.writeLine(2,12,true,"Set");
					else				
						lcd.writeLine(2,12,true,"Clear");
				}
			
				Thread.sleep(1000);
			}
				
			System.out.println(dev40);
	/*		
			//check autonomous
			System.out.println("----- check autonomous start -----");
			for(int i = 0; i < 20; i++){
				double temp = lm.getT();					
				System.out.print("Temperature: "+temp+"   ");
				dev40.autonomous(true);
				
				if(SHOW) {
					lcd.writeLine(2,false,"Temp: "+temp);
										
					dev40.readIOPortsImmediate();
					if(dev40.getPort(0).isBitSet(1))
						lcd.writeLine(2,12,true,"Set");
					else				
					lcd.writeLine(2,12,true,"Clear");
				}
				Thread.sleep(1000);
			}
			dev40.autonomous(false);
			System.out.println("----- check autonomous end -----");
	*/		
			
		}
		catch(Exception e ){
			e.printStackTrace();
		}
		devs.closeAllDevices();
	
	System.exit(0);
	}
}
