package de.wagner_ibw.test;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.isa.Isa8BitSlot;

public class IsaSlotTest {
		
	final static short  BASE = 0x360;	//Basisadresse der LA-Karte
										//	Teilerfaktor  (Datenbits 3-0)
										//	0000 25  ns
										//	0001 50  ns
										//	...
										//	1011 100 s
										//	1111 extern
										//Triggerflanke (Datenbits 5,4)
										//	00 keine Fl.
										//	01 HL-Fl.
										//	10 LH-Fl.

	final static short LBYTE = BASE + 1;	//Eingabeport fr Kanal 1-8
	final static short HBYTE = BASE + 2;	//Eingabeport fr Kanal 9-18
	final static short  SBIT = BASE + 0;	//Eingabeport fr Statussignal

	final static short START = BASE + 0;	//Ausgabeport fr Startsignal
	final static short  STEP = BASE + 2;	//Ausgabeport fr Zhlerstep
	final static short   RES = BASE + 3;	//Ausgabeport fr Zhlerreset,		
		
		
	static IowFactory devs  = null;
	static Iow40      dev40 = null;	
	static Isa8BitSlot slot = null;	
		
		
		
	public static void main(String[] args) {
		
		try {	
			devs  = IowFactory.getInstance();
			dev40 = devs.getIow40Device();
			slot  = new Isa8BitSlot(dev40);
		
			readdata();		
		
		}
		catch(Exception e) {
			devs.exit(-1);
		}
	}
	
//	Auslesen der Hardware und einlesen in das labyte-Array
	static void readdata() {
		int i;
		int lownib,highnib;
		//slot.outp(RES,(short)(0xb | 0));	//Zhler auf null setzen
		slot.outp(RES,(short)(0x6 | 0));
		
		ready();
		
		slot.outp(STEP,(short)0);			//1xstep weil erster Wert ung?ltig
		//for(i=0;i<=32767;i++) {
		for(i=0;i<=32;i++) {
		  	lownib =(slot.inp(LBYTE) /*& 0x00ff*/);
		  	highnib=(slot.inp(HBYTE) /*& 0x00ff*/);
		  	//ss.labyte[i]=(highnib << 8) | lownib;
		  	System.out.println(i + ": " + ((highnib << 8) | lownib));
			slot.outp(STEP,0);  				//1xstep nchste Adresse
		}



	}	
		
	//Warten auf das Ende der Logikanalyse; Abfrage BSY-Bit
	static void ready() {
		int fertig=0;
		do fertig=((slot.inp(SBIT) & 0x0080) >> 7);
		while(fertig==0);
		//gotoxy(60,1);
		//cprintf("      Haupmen?      ");
	}

	//Warten auf das Ende der Logikanalyse bei Triggerung
	int ready_trigger() {
		int fertig=1;
		do {  //warten bis Analyse beginnt
		  	fertig=( (slot.inp(SBIT) & 0x0080) >> 7  );
		  	try {
			  	Thread.sleep(1000);
			  	//if (kbhit()) return(1);
		  	} catch (InterruptedException e) {
			
		  	}
		}
		while(fertig == 1);
		//gotoxy(60,1);
		//cprintf(" Analyse gestartet  ");
		do {  //warten bis Analyse fertig
			  fertig=( (slot.inp(SBIT) & 0x0080) >> 7  );
		  	try {
				Thread.sleep(1000);
			 	//if (kbhit()) return(1);
		  	} catch (InterruptedException e) {
			
			}
		}
		while(fertig == 0);
		//gotoxy(60,1);
		//cprintf("  Analyse beendet   ");
		return(0);
	}	
	
}

