/*
 * $Id: IowTest.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * 
 * Created on 01.01.2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package de.wagner_ibw.test;


import java.util.NoSuchElementException;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.Iow40;



/**
 * It is a simple test program.
 * 
 * @author Thomas Wagner
 *
 */
public class IowTest {
	
	static final boolean CHECK_IOW40 = false;
	static final boolean CHECK_IOW24 = true;
	static final boolean DEBUG       = false;

	static IowFactory   devs;
	static Iow40 dev40;
	static Iow24 dev24;

	public static void main(String[] args) {
		
		IowFactory devs = IowFactory.getInstance();
		System.out.println(devs);
				
		if(CHECK_IOW40){	
			try {	
				dev40 = devs.getIow40Device();
				Iow40Test iow40t = new Iow40Test(dev40,DEBUG);
				iow40t.start();
			}
			catch(NoSuchElementException e) {
				e.printStackTrace();
			}
		}
		
		if(CHECK_IOW24){
			try {
				dev24 = devs.getIow24Device();
				Iow24Test iow24t = new Iow24Test(dev24,DEBUG);
				iow24t.start();
			}
			catch(NoSuchElementException e) {
				e.printStackTrace();
			}
		}
		//devs.closeAllDevices();
		Thread.yield();
	}
}
