/* 
 * This File is part of the iowj-project   
 * $Id: IowCurrentPinStatusReportTest.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.wagner_ibw.test;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.Iow40;

/**
 * This simple test prog checks the current pin status special mode function.
 * It checks one connected IOW40 and/or one connected IOW24 chip. If no chips
 * are connected a NoSuchElementException will be displayed.
 * If you use the IOW-Warrior 40 Starterkit, the key is connected to P0.0. 
 * 
 * @author Thomas Wagner
 * @since 0.9.3
 *
 */
public class IowCurrentPinStatusReportTest {
		
	public static void main(String[] args) {
		System.out.println("***** Check Special Function 'Get Current Pin Status' *****");		
		IowCurrentPinStatusReportTest iit = new IowCurrentPinStatusReportTest();	
		IowFactory devs = IowFactory.getInstance();
						
		try {
			System.out.println("--- Check IOW40 ---");
			Iow40 dev40 = devs.getIow40Device();
						
			long pins40 = dev40.scanPorts();
			System.out.println("Pins: "+pins40 + ", "+ Long.toHexString(pins40)+ ", "+ Long.toBinaryString(pins40));				
			
			System.out.println(dev40);
		}
		catch(Exception e) {
			System.out.println(e);
		}
		
		try {
			System.out.println("--- Check IOW24 ---");
			Iow24 dev24 = devs.getIow24Device();
		
			long pins24 = dev24.scanPorts();
			System.out.println("Pins: "+pins24 + ", "+ Long.toHexString(pins24)+ ", "+ Long.toBinaryString(pins24));							
	
			System.out.println(dev24);
		}
		catch(Exception e) {
			System.out.println(e);
		}
		devs.exit(0);
	}
}

