/* 
 * This File is part of the iowj-project   
 * $Id: Iow40Test.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.wagner_ibw.test;

import java.util.Random;

import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.SpecialModeFunction;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD2x16;

/**
 * It is the base class of all the iow chips, based on the
 * iowkit.dll for Windows.
 * 
 * @author Thomas Wagner
 *
 */
public class Iow40Test extends Thread {
	
	static final boolean CHECK_PORTS = true;
	static final boolean CHECK_LCD   = true;
	
	private Iow40 dev40;
	private boolean debug = false;
	
	Iow40Test(Iow40 dev,boolean debug) {
		dev40 = dev;
		this.debug = debug;
	}
	
	public void run() {
				
		try{	
						
			dev40.getPort(0).setDirection("OOOOOOII"); //Taster, LM75
		  //dev40.getPort(0).setDirection("OOOOOOOI"); //Taster
			dev40.getPort(1).setDirection("OOOOOOOO"); //
			dev40.getPort(2).setDirection("OOOOOOOO"); //
			dev40.getPort(3).setDirection("OOOOOOOO"); //Led
				
			dev40.setPort(0,0x01);
			dev40.setPort(1,0x02);
			dev40.setPort(2,0x03);
			dev40.setPort(3,0x00); //all leds on
			dev40.writeIOPorts();
				
			if(CHECK_PORTS){	
				if(debug) System.out.println(dev40.toString());
			
				dev40.readIOPortsImmediate();
				dev40.readIOPortsImmediate();
				dev40.readIOPortsImmediate();
				
			
				
//				dev40.setTimeout(2000);
//				dev40.readIOPorts();
//				System.out.println(dev40.toString());
//				
//				dev40.readIOPorts();
//				System.out.println(dev40.toString());
//				
//				dev40.readIOPorts();
//				System.out.println(dev40.toString());
//				
				//System.exit(0);
								
				System.out.println("Please press and release the Key\n");
					
				dev40.setTimeout(5000);
				dev40.readIOPorts();
				//System.out.println(dev.toString());
				if(debug) System.out.println("P0["+dev40.getPort(0)+"]");
						
				dev40.setTimeout(1000);
				dev40.readIOPorts();
				//System.out.println(dev.toString());
				if(debug) System.out.println("P0["+dev40.getPort(0)+"]");
							
						
				Random ra = new Random();
				long wr = 0;
				for(int i = 0; i < 40; i++){
					dev40.setPort(3,ra.nextInt());
					dev40.writeIOPorts();
					dev40.readIOPortsImmediate();
					Thread.sleep(50);
				}
				dev40.setPort(3,0x00); //alle led an
				dev40.writeIOPorts();
				dev40.readIOPortsImmediate();
			
				Thread.sleep(1000);
				dev40.setPort(3,0x81); //die ueren aus
				dev40.writeIOPorts();
				dev40.readIOPortsImmediate();
						
				Thread.sleep(1000);
				dev40.setPort(3,0xff); //alle led aus
				dev40.writeIOPorts();
				dev40.readIOPortsImmediate();
			}
			
			if(CHECK_LCD){
					
				AbstractLCD lcd = new LCD2x16();
				dev40.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
				if(debug) System.out.println(dev40.toString());
				//Turn on display, cursor and blinking
				//lcd.setDisplayControl(true, false, false);
				//Set cursor movement to right and no shifting
				//lcd.setEntryMode(true, false);
				 
				
				lcd.setCursorOff();
				Thread.sleep(1000);
				lcd.setCursorOn();
			
				//lcd.print("");	
				Thread.sleep(1000);
				lcd.setCursorHome();
							         //1...5....1....5....2....5....3....5....4
				lcd.writeLine(1,false,"Das ist Mist ...");
				lcd.writeLine(2,false,"Zweite Zeile ...");
				
				Thread.sleep(2000);
				lcd.setCursorOff();
									
				Thread.sleep(100);
				
				if( lcd.getRows() > 2) {
					lcd.writeLine(3,false,"Dies wird die 3.");
					Thread.sleep(100);
					lcd.writeLine(4,false,"vllig anderem !");
				}
							
				Thread.sleep(1000);
				//dev40.disableLCD();
				if(debug) System.out.println(dev40.toString());
			}
		}
		catch(Exception e ){
			e.printStackTrace();
		}
	}
}
