package de.wagner_ibw.test;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.IowPort;
import de.wagner_ibw.iow.IowPortChangeListener;

public class Iow40IoTestListener implements IowPortChangeListener{
		
	/*
	 * Port Changed Callback
	 * @see de.wagner_ibw.iow.IowPortChangeListener#portChanged(de.wagner_ibw.iow.IowPort)
	 */
	public synchronized void  portChanged(IowPort port) {
		System.out.println("portChanged (index:"+port.getIndex()+")," + port.toString());
		
		if(port.getIndex() == 0) {
			if(port.isBitClear(0)) { 
				System.out.println("P0.0 is clear");
			}
			else {
				System.out.println("P0.0 is set");
			}
		}
	}
	
	public static void main(String[] args) {
		Iow40   dev40  = null;
				
		Iow40IoTestListener iit = new Iow40IoTestListener();	
		IowFactory devs = IowFactory.getInstance();
		
		try {
			dev40 = devs.getIow40Device();
			dev40.autonomous(true);			
			dev40.getPort(0).addPortChangeListener(iit);
			//for(int i = 0; i < 10; i++) {
				//dev40.setTimeout(1000);
				//dev40.readIOPorts();
				
				
				//Thread.sleep(1000);
				
				//dev40.readIOPortsImmediate();
				//System.out.println(i + "  " + dev40.getPort(0).toString());
				
				
			//}
			//System.exit(0);
			
		}
		catch(Exception e) {
			System.exit(1);
		}
	}
}

