/*
 * $Id: Iow24Test.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * 
 * Created on 01.01.2004
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package de.wagner_ibw.test;

import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.SpecialModeFunction;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD2x24;

/**
 * It is a simple test program.
 * 
 * @author Thomas Wagner
 *
 */
public class Iow24Test extends Thread {
	
	static final boolean CHECK_PORTS = true;
	static final boolean CHECK_LCD   = true;
	
	private Iow24 dev24;
	private boolean debug = false;

	public Iow24Test(Iow24 dev, boolean debug) {
		dev24 = dev;		
		this.debug = debug;
	}
	
	public void run(){
		try {
		
			AbstractLCD lcd1 = new LCD2x24();
			dev24.addSpecialModeFunctionImpl((SpecialModeFunction)lcd1);
			if(debug) System.out.println(dev24.toString());
			Thread.sleep(100);
			//Turn on display, cursor and blinking
			lcd1.setDisplayControl(true, false, false);
			Thread.sleep(100);
			//Set cursor movement to right and no shifting
			lcd1.setEntryMode(true, false);
			Thread.sleep(100);
				 
			lcd1.writeString("Test");
			
			/*
			Thread.sleep(3000);
			lcd1.setCursorOff();
			Thread.sleep(3000);
			lcd1.setCursorOn();
			*/
			//*Test* lcd1.print("");	
			Thread.sleep(1000);
			lcd1.setCursorHome();
			Thread.sleep(100);
						    //1...5....1....5....2....5....3....5....4
			lcd1.writeString("D");
			Thread.sleep(100);
			lcd1.writeString("a");
			Thread.sleep(100);
			lcd1.writeString("s ");
			Thread.sleep(100);
			Thread.sleep(100);
			lcd1.writeString("i");
			Thread.sleep(100);
			lcd1.writeString("s");
			Thread.sleep(100);
			lcd1.writeString("t ");
			Thread.sleep(100);
			lcd1.writeString("a");
			Thread.sleep(100);
			lcd1.writeString("l");
			Thread.sleep(100);
			lcd1.writeString("les");
			lcd1.writeString(" Mist!");
			lcd1.writeString(" 1234567890");
			lcd1.writeString(" abcdefghijklmnopqrstuvwxyz");
			Thread.sleep(2000);
			
			lcd1.setCursorHome();
			lcd1.writeString("........................");
		/*
			lcd1.clearLCD();
			lcd1.setCursorOff();
		*/
		/*
			lcd1.writeString("Das ist Mist ...xxxxxxxxxxxxxxxxxxxxXxxx");
			Thread.sleep(100);
			lcd1.writeString("Zweite Zeile ...xxxxxxxxxxxxxxxxxxxXxxxx");
			Thread.sleep(100);
			lcd1.writeString("Dies wird die dritte Zeile auf einem----");
			Thread.sleep(100);
			lcd1.writeString("v�llig anderem Display (Zeile 4)!!!!!!!!");
		*/
		
		
			//dev24.setTimeout(1000);
			dev24.getPort(0).setDirection("OOOOOIIO");
			dev24.autonomous(true);
	
			for(int i = 0; i < 20; i++) {		
				//dev24.readIOPortsImmediate();
				System.out.println(dev24.getPort(0));
				if(dev24.getPort(0).isBitClear(1)) { 
					lcd1.setCursorHome();
					lcd1.writeLine(2,true,"Garage");
				}
				else if(dev24.getPort(0).isBitClear(2)) { 
					lcd1.setCursorHome();
					lcd1.writeLine(2,true,"Tankstelle");
				}
				else { 
					lcd1.setCursorHome();
					lcd1.writeLine(2,true,"Unbekannt");
				}
				Thread.sleep(2000);
			}	
			dev24.autonomous(false);
						
		}
		catch(Exception e ){
			e.printStackTrace();
		}
	}	
}
