/*
 * This File is part of the iowj-project   
 * $Id: Iow24IoTestWhile.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.wagner_ibw.test;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow24;

/**
 * Simple program to show the simpliest way (not the best) to read
 * the Iow40's input pins. This program never ends.
 * 	 
 * @author Thomas Wagner
 */
public class Iow24IoTestWhile {
		
	public static void main(String[] args) {
				
		Iow24IoTestWhile iit = new Iow24IoTestWhile();	
		IowFactory devs = IowFactory.getInstance();
		
		boolean run = true;
		
		try {
			Iow24 dev24 = devs.getIow24Device();
			
			dev24.setTimeout(2000);
				
			long pins = 0;
			while(run) {
				pins = dev24.readIOPorts();
				System.out.println("Pins: "+pins + ", "+ Long.toHexString(pins)+ ", "+ Long.toBinaryString(pins));				
				if( pins != 0) {
					
					int portval0 = dev24.getPort(0).getData();
					int portval1 = dev24.getPort(1).getData();
				
					System.out.print("P1["+Integer.toBinaryString(portval1)+"],");
					System.out.println("P0["+Integer.toBinaryString(portval0)+"]");
				
					boolean pressed =  dev24.getPort(0).isBitClear(1);
					System.out.println("Key (P0.1) is pressed? "+pressed+"\n");
					//now do anything with this information
				}	
				//check end of loop condition -> run = flase
			}
		}
		catch(Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}
	}
}

