/* 
 * This File is part of the iowj-project  
 * $Id$
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.lcd.GLCD128x128;

/**
 * TODO:
 * This simple test prog checks the class LCD and the connected
 * dot matrix character display.
 * If CHECK_24 is true an IOW24 chip is expected otherwise an IOW40 chip
 * should be connected.
 * In the LCD constructor, choose a appropriate LCDxxxxGeneric description class:
 * <ul>
 *   <li>LCD1x24Generic</li>
 *   <li>LCD2x16Generic</li>
 *   <li>LCD2x20Generic</li>
 * 	 <li>LCD2x24Generic</li>
 *   <li>LCD4x16Generic</li>
 *   <li>LCD4x20Generic</li>
 * </ul> 
 * 
 * @author Thomas Wagner
 * @since 0.9.5
 *
 */ 
public class GlcdTLXTest {
	
		
	public static void main(String[] args) {
		System.out.println("***** Check class GLCD128x128 and any connected display *****");
				
		IowFactory devs = null;
		
		try {
			GLCD128x128 lcd;
			devs  = IowFactory.getInstance();
				
			Iow40 dev40 = devs.getIow40Device();
			lcd = new GLCD128x128(dev40,true);
					
			
			//Turn on display, cursor off and blinking off
			lcd.setDisplayControl(true, false, false);
	
			//show greetings
			lcd.writeLine(1,2,false, "Test GLCD class");
			Thread.sleep(2000);
			
			lcd.cls();
			lcd.home();

			for(int i = 0; i < 128; i++) {
				lcd.pset(i,i);
			}
			
			lcd.rechteck(3,4,23,56);
			lcd.rechteck(5,6,21,54);
			lcd.rechteck(63,64,123,126);
			lcd.linie(30,40,60,50);
			lcd.linie(50,40,60,50);
			lcd.linie(70,40,60,50);
			lcd.circle (10,10,1);
			lcd.circle (30,30,3);
			lcd.circle (50,40,10);
			lcd.circle (130,50,30);
		  	lcd.circle (40,60,5);
		  	lcd.circle (30,30,23);
				
			Thread.sleep(2000);
			//clear the display
			lcd.clearLCD();
			lcd.writeLine(lcd.getRows(),5,true, "The End");
			devs.exit(0);
		}
		catch(Exception e) {
			System.out.println(e);
			devs.exit(1);
		}
	}
}
