/* 
 * This File is part of the iowj-project  
 * $Id: DoubleLcdTest.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.SpecialModeFunction;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD4x40Ahw;

/**
 * This simple test prog checks the class DoubleLCDImpl and the connected
 * dot matrix character display.
 * If CHECK_24 is true an IOW24 chip is expected otherwise an IOW40 chip
 * should be connected.
 * In the LCD constructor, choose a appropriate LCDxxxxGeneric description class:
 * <ul>
 *   <li>LCD4x27Generic</li>
 *   <li>LCD4x40Generic</li>
 * </ul> 
 * 
 * @author Thomas Wagner
 * @since 0.9.4
 *
 */ 
public class DoubleLcdTest {
	
	final static boolean CHECK_24 = false;
	
	public static void main(String[] args) {
		System.out.println("***** Check class DoubleLCD and any connected display *****");
		
		IowFactory devs = null;
		
		try {
			AbstractLCD lcd;
			devs  = IowFactory.getInstance();
						
			if(CHECK_24) {
				Iow24 dev24 = devs.getIow24Device();
				lcd = new LCD4x40Ahw(0,0);
				dev24.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
			}
			else {
				Iow40 dev40 = devs.getIow40Device();
				lcd = new LCD4x40Ahw(0,0);
				dev40.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
			}
			
			//Turn on display, cursor off and blinking off
			lcd.setDisplayControl(true, false, false);
	
			//show greetings
			lcd.writeLine(1,2,false, "Test DoubleLCD class");
			Thread.sleep(2000);
			
			//check LCD
			lcd.check();
			Thread.sleep(2000);
			
			//clear the display
			lcd.clearLCD();
	
			//build 8 special characters (several bars)
	
			          //upper                              lower
			int[] c0 = {0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f};
			int[] c1 = {0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x00};
			int[] c2 = {0x1f,0x1f,0x1f,0x1f,0x1f,0x1f,0x00,0x00};
			int[] c3 = {0x1f,0x1f,0x1f,0x1f,0xff,0x00,0x00,0x00};
			int[] c4 = {0x1f,0x1f,0x1f,0x1f,0x00,0x00,0x00,0x00};
			int[] c5 = {0x1f,0x1f,0x1f,0x00,0x00,0x00,0x00,0x00};
			int[] c6 = {0x1f,0x1f,0x00,0x00,0x00,0x00,0x00,0x00};
			int[] c7 = {0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
			
			//load them up
			lcd.setSpecialChar(0,c0);
			lcd.setSpecialChar(1,c1);
			lcd.setSpecialChar(2,c2);
			lcd.setSpecialChar(3,c3);
			lcd.setSpecialChar(4,c4);
			lcd.setSpecialChar(5,c5);
			lcd.setSpecialChar(6,c6);
			lcd.setSpecialChar(7,c7);
			
			//show them in line 1
			lcd.writeLine(1,true,"\0\1\2\3\4\5\6\7");
			//show them in line 4
			lcd.writeLine(4,true,"\0\1\2\3\4\5\6\7");
			Thread.sleep(2000);
			
			//build 6 special characters for pictures (cars)
			int[] a0 = {0x00,0x00,0x01,0x0f,0x1f,0x1f,0x0f,0x06};
			int[] a1 = {0x0f,0x1f,0x1f,0x1f,0x1f,0x1f,0x00,0x00};
			int[] a2 = {0x1c,0x1c,0x1e,0x1e,0x1f,0x1f,0x1e,0x0c};
			int[] a3 = {0x07,0x07,0x0f,0x0f,0x1f,0x1f,0x0f,0x06};
			int[] a4 = {0x1e,0x1f,0x1f,0x1f,0x1f,0x1f,0x00,0x00};
			int[] a5 = {0x00,0x00,0x10,0x1e,0x1f,0x1f,0x1e,0x0c};
			
			//load them up
			lcd.setSpecialChar(0,a0);
			lcd.setSpecialChar(1,a1);
			lcd.setSpecialChar(2,a2);
			lcd.setSpecialChar(3,a3);
			lcd.setSpecialChar(4,a4);
			lcd.setSpecialChar(5,a5);
			
			//show them in line 1
			lcd.writeLine(1,true,"\0\1\2  \3\4\5");
			//show them in line 4
			lcd.writeLine(4,true,"\0\1\2  \3\4\5");

			Thread.sleep(2000);
			
			//move the car from left to right
			lcd.moveSprite(1,new String[]{"\3\4\5"},200);
			lcd.moveSprite(4,new String[]{"\3\4\5"},200);
			Thread.sleep(2000);
				
			//build 4 special characters for an animated sprite
			int[] d0 = {0x00,0x04,0x04,0x04,0x04,0x04,0x00,0x00};
			int[] d1 = {0x00,0x01,0x02,0x04,0x08,0x10,0x00,0x00};
			int[] d2 = {0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00};
			int[] d3 = {0x00,0x10,0x08,0x04,0x02,0x01,0x00,0x00};
			
			//load them up
			lcd.setSpecialChar(0,d0);
			lcd.setSpecialChar(1,d1);
			lcd.setSpecialChar(2,d2);
			lcd.setSpecialChar(3,d3);
			
			//moves the sprite from left to right
			lcd.moveSprite(1,new String[]{"\0","\1","\2","\3"},200);
			lcd.moveSprite(4,new String[]{"\0","\1","\2","\3"},200);

			
			Thread.sleep(2000);
			//clear the display
			lcd.clearLCD();
			lcd.writeLine(lcd.getRows(),5,true, "The End");
					
			devs.exit(0);
		}
		catch(Exception e) {
			System.out.println(e);
			devs.exit(1);
		}
	}
}
