/*
 * This File is part of the iowj-project   
 * $Id: DoubleI2CTest.java,v 1.1.1.1 2006/01/15 16:47:28 Thomas Wagner Exp $
 * Copyright (C)2004 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.SpecialModeFunction;
import de.wagner_ibw.iow.i2c.I2C;
import de.wagner_ibw.iow.i2c.LM75;
import de.wagner_ibw.iow.i2c.PCF8570;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD2x24;

/**
 * It is a simple test program for I2C and LM75.
 * @author Thomas Wagner
 */
public class DoubleI2CTest implements Runnable {
	
	static boolean DEBUG = false;
	static boolean LOOP = false;
	static boolean SHOW = false;

	private IowFactory   devs;
	private Iow24 dev24;
	private AbstractLCD   lcd;
	
	/**
	 * Constructor for stand-alone operation.
	 */
	public DoubleI2CTest() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
	}
	
	/**
	 * Contructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
//	public DoubleI2CTest(IowFactory devs) {
//		this.devs = devs;
//	}
	
	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */
	public static void main(String[] args) {
		DoubleI2CTest pcf = new DoubleI2CTest();
		pcf.doit();
		if(SHOW) {
			pcf.lcd.clearLCD();
		}
		pcf.devs.exit(0);
	}

	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}
	
	
	/**
	 * Do all that work.
	 */
	private void doit() {
			
		PCF8570 pc = null;
		LM75 lm = null;
					
		try{
			dev24 = devs.getIow24Device("00000153");
						 
			I2C i2c = new I2C();  
			dev24.addSpecialModeFunctionImpl(i2c);
			
			 
			lm = new LM75(0x0);
		  	i2c.addI2CDevice(lm);
			 
			pc = new PCF8570(0x0);
			i2c.addI2CDevice(pc);
			
			
			
			//Thread.sleep(2000);
			
			System.out.println(pc);
			
			
			if(SHOW){
				lcd = new LCD2x24();
				dev24.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
				
				
				//Turn on display, cursor and blinking
				lcd.setDisplayControl(true, false, false);
				//Set cursor movement to right and no shifting
				lcd.setEntryMode(true, false);
				
				lcd.writeLine(1,true,"IOW24 PCF8570 Demo");
//				Thread.sleep(2000);
			}
			
							
			System.out.println(dev24.toString());
				
			for(int i = 0; i < 8; i++) {
				pc.write(i,10+i);
				System.out.println("--- ReadRam at addr "+i+": " + pc.read(i)+ "  " + lm.getT());		
			}	
	
	
			int data[] = pc.readPage(0,4);
			for ( int i = 0; i < 4; i++) {
				System.out.println(data[i]);
			}
			data = pc.readPage(4,4);
			for ( int i = 0; i < 4; i++) {
				System.out.println(data[i]);
			}
	
	
				
			//System.out.println(dev24);
	/*		
			//check autonomous
			System.out.println("----- check autonomous start -----");
			for(int i = 0; i < 20; i++){
				double temp = lm.getT();					
				System.out.print("Temperature: "+temp+"   ");
				dev40.autonomous(true);
				
				if(SHOW) {
					lcd.writeLine(2,false,"Temp: "+temp);
										
					dev40.readIOPortsImmediate();
					if(dev40.getPort(0).isBitSet(1))
						lcd.writeLine(2,12,true,"Set");
					else				
					lcd.writeLine(2,12,true,"Clear");
				}
				Thread.sleep(1000);
			}
			dev40.autonomous(false);
			System.out.println("----- check autonomous end -----");
	*/		
			
		}
		catch(Exception e ){
			e.printStackTrace();
		}
	}
}
