/*
 * This File is part of the iowj-project   
 * $Id
 * Copyright (C)2006 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.spi.AT25080A;
import de.wagner_ibw.iow.spi.SPI;

/**
 * It is a simple test program for the M95020 spi device.
 * @author Thomas Wagner
 */
public class AT25080ATest implements Runnable {
	
	
	private IowFactory   devs;
	private AbstractIowDevice dev;
		
	/**
	 * Constructor for stand-alone operation.
	 */
	public AT25080ATest() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
	}
	
	/**
	 * Contructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
	public AT25080ATest(IowFactory devs) {
		this.devs = devs;
	}
	
	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */
	public static void main(String[] args) {
		AT25080ATest st = new AT25080ATest();
		st.doit();
		st.devs.exit(0);
	}

	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}
	
	
	/**
	 * Do all that work.
	 */
	private void doit() {
							
		try{
			dev = devs.getIowDevice();
					
			//SPI spi = new SPI(0x02); //IOW24							 
			SPI spi = new SPI(0x00,40); // 0x0fCPOL=CPHA=1 and 1MBit/sec  
			dev.addSpecialModeFunctionImpl(spi);
						 
			AT25080A m = new AT25080A();
			
			spi.setSPIDevice(m);
			
			System.out.println(m);
			System.out.println(dev.toString());
			
			
/*			
			for(int i = 0; i < 1024; i++) {
				int addrLow = i & 0xff;
				int addrHigh = (i & 0xff00) >> 8;
				System.out.println("Address: "+ i +", HWT: "+ addrHigh+", LWT: " +addrLow);
			}
*/			
	
//			System.out.println("writeEnable...");
//			System.out.println("StatusReg: "+ Integer.toHexString(m.readStatusReg()));
//			m.writeStatusReg(0xff);
//			System.out.println("StatusReg: "+ Integer.toHexString(m.readStatusReg()));
			System.out.println(m.toString());
//*		
			System.out.println("Read 0 : "+ m.read(0));
			System.out.println("Read 1 : "+ m.read(1));
			System.out.println("Read 2 : "+ m.read(2));
			System.out.println("Read 3 : "+ m.read(3));
			
					
			m.write(0,'H');
			m.write(1,'a');
			m.write(2,'u');
			m.write(3,'s');
						
			System.out.println("Read 0 : "+ (char)m.read(0));
			System.out.println("Read 1 : "+ (char)m.read(1));
			System.out.println("Read 2 : "+ (char)m.read(2));
			System.out.println("Read 3 : "+ (char)m.read(3));
	//*/	

/*	
	for(int i = 0; i < 1024; i++) {
		m.write(i,'A');
	}
	for(int i = 0; i < 1024; i++) {
		System.out.print((char)m.read(i));
	}
	System.out.println();
*/	
	
			m.fillEeprom('?');
//*
			int b[] = {'O','t','t','o',' ','M','u','e','l','l','e','r',' ',' ',' ','|',
				       'u','n','d',' ','L','i','s','e',' ','M','e','i','e','r',' ','|'};
			m.writePage(0,b);
			int r[] = m.readPage(0,b.length);
					
			for(int i = 0; i < r.length; i++) {
				System.out.print((char)r[i]);
			}
			System.out.println();
//*/	
			r = m.readPage(0,1024);
					
			for(int i = 0; i < r.length; i++) {
				System.out.print((char)r[i]);
				//System.out.println(i + "\t" +(char)r[i]+ "\t" + Integer.toHexString(r[i]));
			}
			System.out.println();
			
			
  			m.fillEeprom('+');
			r = m.readPage(0,1024);
					
			for(int i = 0; i < r.length; i++) {
				System.out.print((char)r[i]);
				//System.out.println(i + "\t" +(char)r[i]);
			}
			System.out.println();
			
			
			
			devs.exit(0);
		}
		catch(Exception e ){
			e.printStackTrace();
		}
	}
}
