/*
 * This File is part of the iowj-project   
 * $Id$
 * Copyright (C)2006 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.test;

import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.SpecialModeFunction;
import de.wagner_ibw.iow.i2c.AT24C128;
import de.wagner_ibw.iow.i2c.I2C;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD2x24;

/**
 * It is a simple test program for I2C and LM75.
 * @author Thomas Wagner
 */
public class AT24C128Test implements Runnable {
	
	static boolean DEBUG = false;
	static boolean LOOP = false;
	static boolean SHOW = false;

	private IowFactory   devs;
	private AbstractIowDevice dev;
	private AbstractLCD   lcd;
	
	/**
	 * Constructor for stand-alone operation.
	 */
	public AT24C128Test() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
	}
	
	/**
	 * Contructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
//	public PCF8570Test(IowFactory devs) {
//		this.devs = devs;
//	}
	
	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */
	public static void main(String[] args) {
		AT24C128Test at = new AT24C128Test();
		at.doit();
		if(SHOW) {
			at.lcd.clearLCD();
		}
		at.devs.exit(0);
	}

	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}
	
	
	/**
	 * Do all that work.
	 */
	private void doit() {
			
		AT24C128 pc = null;
					
		try{
			dev = devs.getIowDevice();
						 
			I2C i2c = new I2C(I2C.I2C_SPEED_400KHZ);
			try { 
				dev.addSpecialModeFunctionImpl(i2c);
			} catch (IllegalArgumentException i) {
				i2c = (I2C) dev.getSpecialModeFunctionImpl("I2C");
			}
			 
			pc = new AT24C128(0x0);
			
			i2c.addI2CDevice(pc);
			
			System.out.println("----- AT24C128Test -----\n"+dev);
			//System.out.println(pc);
			
			
			if(SHOW){
				lcd = new LCD2x24();
				dev.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
				
				
				//Turn on display, cursor and blinking
				lcd.setDisplayControl(true, false, false);
				//Set cursor movement to right and no shifting
				lcd.setEntryMode(true, false);
				
				lcd.writeLine(1,true,"IOW24 AT24C128 Demo");
//				Thread.sleep(2000);
			}
			
							
			//System.out.println(dev24.toString());
/*				
			for(int i = 0; i < 8; i++) {
				try {
					pc.write(i,110+i);
				} catch(Exception e) {
					System.out.println(e);
				}
				
				
				System.out.println("--- ReadEeprom at addr "+i+": " + pc.read(i));		
			}	
	
	
			int data[] = pc.readPage(0,4);
			for ( int i = 0; i < 4; i++) {
				System.out.println(data[i]);
			}
			data = pc.readPage(4,4);
			for ( int i = 0; i < 4; i++) {
				System.out.println(data[i]);
			}
	
			//block write
			int out[] = new int[64];
			for(int i = 0; i < 64; i++) {
				out[i] = 10+i;
			}
			System.out.println("--- check writePage(int[64]) ---");
			pc.writePage(0,out);
*/			
			System.out.println("--- check readPage() ---");
			int data[] = pc.readPage(0,64);
			for ( int i = 0; i < data.length; i++) {
				System.out.println("addr: "+i+","+data[i]);
			}
			
			System.out.println("--- check fillEeprom(55) ---");
//			pc.fillEeprom(55);
			System.out.println("--- readPage(254) ---");
			data = pc.readPage(0,254);
			for ( int i = 0; i < data.length; i++) {
				System.out.println("addr: "+i+","+data[i]);
			}
			
			System.out.println("--- readPage(hole size) ---");
			data = pc.readPage(0,pc.EEPROM_SIZE-1);
			for ( int i = 0; i < data.length; i++) {
				System.out.println("addr: "+i+","+data[i]);
			}
			
			System.out.println("------ "+this.getClass().getName()+" ende------");
//			data = pc.readPage(0,8);
//			for ( int i = 0; i < 8; i++) {
//				System.out.println(data[i]);
//			}
				
			//System.out.println(dev24);
	/*		
			//check autonomous
			System.out.println("----- check autonomous start -----");
			for(int i = 0; i < 20; i++){
				double temp = lm.getT();					
				System.out.print("Temperature: "+temp+"   ");
				dev40.autonomous(true);
				
				if(SHOW) {
					lcd.writeLine(2,false,"Temp: "+temp);
										
					dev40.readIOPortsImmediate();
					if(dev40.getPort(0).isBitSet(1))
						lcd.writeLine(2,12,true,"Set");
					else				
					lcd.writeLine(2,12,true,"Clear");
				}
				Thread.sleep(1000);
			}
			dev40.autonomous(false);
			System.out.println("----- check autonomous end -----");
	*/		
			
		}
		catch(Exception e ){
			e.printStackTrace();
		}
	}
}
