/*
 * This File is part of the iowj-project   
 * $Id: SwitchMatrixExample.java,v 1.1.1.1 2006/01/15 16:47:26 Thomas Wagner Exp $
 * Copyright (C)2004 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.examples;


import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD4x40Ahw;
import de.wagner_ibw.iow.smx.SwitchMatrix;
import de.wagner_ibw.iow.smx.SwitchMatrixChangeListener;
import de.wagner_ibw.iow.smx.SwitchMatrixEvent;
import de.wagner_ibw.iow.smx.SwitchMatrixKeyMap;


/**
 * It is a simple example program for the switch matrix.
 * 
 * @author Thomas Wagner
 *
 */
public class SwitchMatrixExample implements Runnable,SwitchMatrixChangeListener{
	
	static boolean SHOW = true;

	private IowFactory   devs;
	private Iow40 dev40;
	private AbstractLCD	  lcd;
	private SwitchMatrixKeyMap smkm;
	
	int lastCol = 0;
	int lastRow = 0;
	
	public  SwitchMatrixExample() {
		devs = IowFactory.getInstance();
		if( devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		}
	}
	
	public  SwitchMatrixExample(IowFactory devs) {
		this.devs = devs;
	}
	
	public void run() {
		doit();
	}
	
	public static void main(String[] args) {
		SwitchMatrixExample sme = new SwitchMatrixExample();
		sme.doit();
		//sme.lcd.clearLCD();
		sme.devs.exit(0);
	}
	
	private void doit() {
			
		try{
			dev40 = devs.getIow40Device();
			
			System.out.println(dev40.toString());
						 
			SwitchMatrix sm = new SwitchMatrix();  
			dev40.addSpecialModeFunctionImpl(sm);
			
			//System.out.println(lm);
			
						
			
			if(SHOW){
				lcd = new LCD4x40Ahw(0,0);
				dev40.addSpecialModeFunctionImpl(lcd);
				
				//Turn on display, cursor and blinking
				lcd.setDisplayControl(true, false, false);
				//Set cursor movement to right and no shifting
				lcd.setEntryMode(true, false);
				
				lcd.writeLine(1,true,"IOW40");
				lcd.writeLine(2,true,"Switch");
				lcd.writeLine(3,true,"Matrix");
				lcd.writeLine(4,true,"Demo");
				Thread.sleep(2000);

				lcd.writeLine(1,8,true, "[ ] [ ] [ ] [ ]");
				lcd.writeLine(2,8,true, "[ ] [ ] [ ] [ ]");
				lcd.writeLine(3,8,true, "[ ] [ ] [ ] [ ]");
				lcd.writeLine(4,8,true, "[ ] [ ] [ ] [ ]");
			}
			
							
			System.out.println(dev40.toString());
			
			//String keyMap[][] = {{"0","1","2","3"},{"4","5","6","7"},{"8","9","A","B"},{"C","D","E","F"}};
			String keyMap[][] = {{"3","2","1","0"},{"7","6","5","4"},{"B","A","9","8"},{"F","E","C","D"}};
			smkm = new SwitchMatrixKeyMap(keyMap);
			
				
			sm.scanMatrix();
			System.out.println(sm);
			
			sm.addSwitchMatrixChangeListener(this);
			
			System.out.println("MIN_LONG: "+ Long.toHexString(Long.MAX_VALUE));
			System.out.println("MIN_LONG: "+ Long.toBinaryString(Long.MAX_VALUE));
			System.out.println("MAX_LONG: "+ Long.toHexString(Long.MAX_VALUE));
			System.out.println("MAX_LONG: "+ Long.toBinaryString(Long.MAX_VALUE));
							
			while(true) {
				Thread.sleep(1000);		
			}
			
			//devs.exit(0);
		
		}
		catch(Exception e ){
			e.printStackTrace();
		}
	}
	/* (non-Javadoc)
	 * @see de.wagner_ibw.iow.SwitchMatrixChangeListener#matrixChanged(de.wagner_ibw.iow.SwitchMatrixEvent)
	 */
	public void matrixChanged(SwitchMatrixEvent event) {
		System.out.println(event);
		int col = event.getRow();
		int row = event.getCol();
		int dcol= 0;
		
		if (col == 1) dcol = 21; //38;
		else if (col == 2) dcol = 17; //34;
		else if (col == 3) dcol = 13; //30;
		else if (col == 4) dcol = 9;  //26; 
			
		if (lastRow != 0 && lastCol != 0) {
			lcd.setCursor(lastRow, lastCol);
			lcd.writeString(" ");
		}
		
		if (row != 0 && col != 0) {
			lcd.setCursor( row ,dcol );
			//lcd.writeString("*");
			String label = smkm.getLabel(event);
			if (label != null)
				lcd.writeString(label);
			lastRow = row ;
			lastCol = dcol;
		}
	}

}
