/*
 * This File is part of the iowj-project   
 * $Id$
 * Copyright (C)2007 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.examples;


import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.smx.SwitchMatrix;
import de.wagner_ibw.iow.smx.SwitchMatrixChangeListener;
import de.wagner_ibw.iow.smx.SwitchMatrixEvent;
import de.wagner_ibw.iow.smx.SwitchMatrixKeyMap;


/**
 * It is a simple example program for the switch matrix special mode function.
 * It works with IOW40 and IOW56
 * 
 * @author Thomas Wagner
 *
 */
public class SimpleSwitchMatrixExample implements Runnable,SwitchMatrixChangeListener{
		
	private IowFactory   devs;
	private AbstractIowDevice dev;
	private SwitchMatrixKeyMap smkm;
	
	int lastCol = 0;
	int lastRow = 0;
	
	public  SimpleSwitchMatrixExample() {
		devs = IowFactory.getInstance();
		if( devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		}
	}
	
	public  SimpleSwitchMatrixExample(IowFactory devs) {
		this.devs = devs;
	}
	
	public void run() {
		doit();
	}
	
	public static void main(String[] args) {
		SimpleSwitchMatrixExample ssme = new SimpleSwitchMatrixExample();
		ssme.doit();
		ssme.devs.exit(0);
	}
	
	private void doit() {
			
		try{
			dev = devs.getIowDevice();
			
			System.out.println(dev.toString());
						 
			SwitchMatrix sm = new SwitchMatrix();  
			dev.addSpecialModeFunctionImpl(sm);
			
			//System.out.println(lm);
							
							
			System.out.println(dev.toString());
			
			//String keyMap[][] = {{"0","1","2","3"},{"4","5","6","7"},{"8","9","A","B"},{"C","D","E","F"}};
			String keyMap[][] = {{"3","2","1","0"},{"7","6","5","4"},{"B","A","9","8"},{"F","E","C","D"}};
			smkm = new SwitchMatrixKeyMap(keyMap);
			
				
			sm.scanMatrix();
			System.out.println(sm);
			
			sm.addSwitchMatrixChangeListener(this);
									
			while(true) {
				Thread.sleep(1000);		
			}
			
			//devs.exit(0);
		
		}
		catch(Exception e ){
			e.printStackTrace();
		}
	}
	/* (non-Javadoc)
	 * @see de.wagner_ibw.iow.SwitchMatrixChangeListener#matrixChanged(de.wagner_ibw.iow.SwitchMatrixEvent)
	 */
	public void matrixChanged(SwitchMatrixEvent event) {
		System.out.println(event);
			
	}

}
