/* 
 * This File is part of the iowj-project  
 * $Id: Rc5Example.java,v 1.1.1.1 2006/01/15 16:47:26 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.examples;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.SpecialModeFunction;
import de.wagner_ibw.iow.lcd.AbstractLCD;
import de.wagner_ibw.iow.lcd.LCD2x24;
import de.wagner_ibw.iow.rc5.RC5;
import de.wagner_ibw.iow.rc5.RC5Event;
import de.wagner_ibw.iow.rc5.RC5KeyChangeListener;

/**
 * This simple example prog checks the class RC5 and shows the scanned RC5 codes
 * on the display. The output should be like this (depends on your pressed key ;-)
 * <pre>
 * Code Addr  Toogle C6
 * 8    5     false  true
 * </pre>
 * If you do not have any display set LCD = false.
 * This prog terminates after 20 seconds.
 * 
 * @author Thomas Wagner
 * @since 0.9.2
 */ 
public class Rc5Example implements RC5KeyChangeListener {
	
	final static boolean LCD = true;
	IowFactory   devs;
	Iow24 dev24; 
	AbstractLCD   lcd;
	
	public static void main(String[] args) {
		Rc5Example rc5t = new Rc5Example();
		rc5t.doIt();
	}
	
	public void doIt() { 
		try {
			RC5 rc5;
			devs  = IowFactory.getInstance();
			if( devs.getNumDevices() == 0) {
				System.out.println("Cannot find any connected IOW device(s)!");
				devs.exit(-1);
			}
						
			dev24 = devs.getIow24Device();
			System.out.println(dev24);
			if (LCD) {
				lcd = new LCD2x24();
				dev24.addSpecialModeFunctionImpl((SpecialModeFunction)lcd);
				System.out.println(dev24);
			}
						
			if (LCD) {
				//Turn on display, cursor off and blinking off
				lcd.setDisplayControl(true, false, false);
	
				//show greetings
				lcd.writeLine(1,2,false, "Test RC5");
				Thread.sleep(2000);
			}
			
			rc5 = new RC5();
			dev24.addSpecialModeFunctionImpl(rc5);
			System.out.println(rc5);
			rc5.addKeyChangeListener(this);
			System.out.println(rc5);
						
			System.out.println(dev24);	
			if (LCD) 
				lcd.writeLine(1,true, "Code Addr Toggle C6");
		
			
			Thread.sleep(20000);
			
			if (LCD)
				lcd.writeLine(2,true, "Stop Receiving RC5 Cmds");

			rc5.removeKeyChangeListener(this);			
			dev24.removeSpecialModeFunctionImpl(rc5);		
			System.out.println(dev24);
			
			if (LCD) {
				Thread.sleep(2000);
				//clear the display
				lcd.clearLCD();
				//lcd.check();
				lcd.writeLine(lcd.getRows(),5,true, "The End");
				dev24.removeSpecialModeFunctionImpl((SpecialModeFunction)lcd);
				System.out.println(dev24);
			}
		}
		catch(Exception e) {
			e.printStackTrace();
			System.exit(1);	
		}
		devs.exit(0);
	}

	/* (non-Javadoc)
	 * @see de.wagner_ibw.iow.RC5KeytChangeListener#keyChanged(de.wagner_ibw.iow.RC5Code)
	 */
	public synchronized void keyChanged(RC5Event event) {
		System.out.println(event);
		
		if (LCD) {
			lcd.writeLine(2,true, "" + event.getCode());
			lcd.setCursor(2,6);
			lcd.writeString( "" + event.getAddress());
			lcd.setCursor(2,11);
			lcd.writeString( "" + event.getToggleBit());
			lcd.setCursor(2,18);
			lcd.writeString( "" + event.getC6CommandBit());
		}
	}

}
