/* 
 * This File is part of the iowj-project   
 * $Id: RFSwitch.java,v 1.1.1.1 2006/01/15 16:47:26 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.wagner_ibw.examples;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow24;


public class RFSwitch implements Runnable {

	private int SwitchA   = 0;
	private int SwitchB   = 1;
	private int SwitchC   = 2;
	private int SwitchOn  = 3;
	private int SwitchOff = 4;


	private IowFactory   devs;
	private Iow24 dev24 = null;
	
	/**
	 * Constructor for stand-alone operation.
	 */
	public  RFSwitch() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
	}
	
	/**
	 * Constructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
	public  RFSwitch(IowFactory devs) {
		this.devs = devs;
	}

	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */	
	public static void main(String[] args) {
		RFSwitch rfs = new RFSwitch();
		rfs.doit();
		rfs.devs.exit(0);	//never reached
	} 
	
	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}

	public void switchAon() {
		System.out.println("switch A on ...");
		dev24.clearBit(1,SwitchA);
		dev24.clearBit(1,SwitchOn);
		pulse();
	}
	
	public void switchAoff() {
		System.out.println("switch A off ...");
		dev24.clearBit(1,SwitchA);
		dev24.clearBit(1,SwitchOff);
		pulse();
	}

	public void switchBon() {
		System.out.println("switch B on ...");
		dev24.clearBit(1,SwitchB);
		dev24.clearBit(1,SwitchOn);
		pulse();
	}
	
	public void switchBoff() {
		System.out.println("switch B off ...");
		dev24.clearBit(1,SwitchB);
		dev24.clearBit(1,SwitchOff);
		pulse();
	}

	public void switchCon() {
		System.out.println("switch C on ...");
		dev24.clearBit(1,SwitchC);
		dev24.clearBit(1,SwitchOn);
		pulse();
	}
	
	public void switchCoff() {
		System.out.println("switch C off ...");
		dev24.clearBit(1,SwitchC);
		dev24.clearBit(1,SwitchOff);
		pulse();
	}



	private void pulse() {
		dev24.writeIOPorts();
		try {
			Thread.sleep(300);
		} catch (Exception e) {
		}
		dev24.setPort(1,0xff);
		dev24.writeIOPorts();
	}

	/**
	 * Do all that work.
	 */	
	private void doit() {
		int pause = 200;
				
		try {
			dev24 = devs.getIow24Device();
						
			dev24.setDirection(1, 0x00); //all bits output
			dev24.setPort(1, 0xff); //all bits high
			dev24.writeIOPorts();
			
			/*
			dev24.setDirection(0, 0xf7); //all bits output
			dev24.setPort(0, 0x00); //all bits high
			dev24.writeIOPorts();
			*/
			
			//switchCon();
			//switchBoff();
			//switchBon();
			switchAoff();
			Thread.sleep(3000);
			//switchBon();
			//switchBoff();
			//switchCoff();
			switchAon();
			System.out.println("end");
						
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	

	
}
