/* 
 * This File is part of the iowj-project   
 * $Id: MultThreadTest.java,v 1.1.1.1 2006/01/15 16:47:26 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
package de.wagner_ibw.examples;

import de.wagner_ibw.iow.IowFactory;

/**
 * This simple prog shows you how you can start more than one modules.
 * 
 * @author Thomas Wagner
 */
public class MultThreadTest {

	public static void main(String[] args) {

		IowFactory devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
		
		Thread iot24 = new Thread(new Iow24IoTest(devs));
		iot24.start();

		Thread iot40 = new Thread(new Iow40IoTest(devs));
		iot40.start();
		

		/*
		Thread cl = new Thread(new CarLocalisationNew(devs));
		cl.start();

		Thread lm75t = new Thread(new LM75Test(devs));
		lm75t.start();
		*/

	}
}
