/* 
 * This File is part of the iowj-project   
 * $Id: Iow40IoTest.java,v 1.1.1.1 2006/01/15 16:47:26 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.wagner_ibw.examples;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow40;
import de.wagner_ibw.iow.IowPort;
import de.wagner_ibw.iow.IowPortChangeListener;

public class Iow40IoTest implements Runnable,IowPortChangeListener {

	private IowFactory   devs;
	private Iow40 dev40 = null;
	
	/**
	 * Constructor for stand-alone operation.
	 */
	public  Iow40IoTest() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
	}
	
	/**
	 * Constructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
	public  Iow40IoTest(IowFactory devs) {
		this.devs = devs;
	}

	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */	
	public static void main(String[] args) {
		Iow40IoTest iot = new Iow40IoTest();
		iot.doit();
		iot.devs.exit(0);	//never reached
	} 
	
	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}

	/**
	 * Do all that work.
	 */	
	private void doit() {
		int pause = 200;
				
		try {
			dev40 = devs.getIow40Device();
			dev40.setDirection(3, 0x00); //all bits output
			
			
			
			dev40.setPort(3, 0x00);	//alles ein
			dev40.writeIOPorts();
			Thread.sleep(pause);

			dev40.setPort(3, 0x01);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x02);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x04);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x08);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x10);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x20);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x40);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x80);
			dev40.writeIOPorts();
			Thread.sleep(pause);

			dev40.setPort(3, 0xff); //alles aus
			dev40.writeIOPorts();
			Thread.sleep(pause);

			dev40.setPort(3, 0xfe);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0xfd);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0xfb);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0xf7);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0xef);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0xdf);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0xbf);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x7f);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x7f);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			dev40.setPort(3, 0x7f);
			dev40.writeIOPorts();
			Thread.sleep(pause);
			
			dev40.setPort(3, 0xff); //alles aus
			dev40.writeIOPorts();
			Thread.sleep(pause);

			dev40.setPort(3, 0xbf);
			dev40.writeIOPorts();
			System.out.println("OUT portChanged (index:3)," + dev40.getPort(3));

			dev40.autonomous(true);			
			System.out.println(dev40);
			dev40.getPort(0).addPortChangeListener(this);
			System.out.println(dev40);
			
			while(true) { //endless loop
				Thread.sleep(100000);
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/*
	 * Port changed callback.
	 * @see de.wagner_ibw.iow.IowPortChangeListener#portChanged(de.wagner_ibw.iow.IowPort)
	 */
	public synchronized void portChanged(IowPort port) {
		//*deb*/System.out.println("\nIN  portChanged (index:" + port.getIndex() + ")," + port.toString());

		if (port.getIndex() == 0) {
			if (port.isBitClear(0)) {
				dev40.clearBit(3, 0);	//led on
				//*deb*/System.out.println("OUT portChanged (index:3)," + dev40.getPort(3));
				System.out.println("P0.0 is clear");
				dev40.writeIOPorts();
			} else {
				
				//*deb*/System.out.println("OUT portChanged (index:3)," + dev40.getPort(3));
				System.out.println("P0.0 is set");
				dev40.setBit(3, 0);		//led off
				dev40.writeIOPorts();
			}
		}
	}
	
}
