/* 
 * This File is part of the iowj-project   
 * $Id: Iow24IoTest.java,v 1.1.1.1 2006/01/15 16:47:26 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.wagner_ibw.examples;

import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.Iow24;
import de.wagner_ibw.iow.IowPort;
import de.wagner_ibw.iow.IowPortChangeListener;

/**
 * Simple IO test prog for IO Warrior 24. This prog flashes the LED and
 * scans two keys connected on P0.1 and P0.2.
 * @author Thomas Wagner
 */
public class Iow24IoTest implements Runnable,IowPortChangeListener {

	private IowFactory   devs;
	private Iow24 dev24 = null;
		
	/**
	 * Constructor for stand-alone operation.
	 */
	public Iow24IoTest() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any connected IOW device(s)!");
			devs.exit(-1);
		} 
	}
	
	/**
	 * Constructor for use as part of an application (independent thread).
	 * @param devs The initialized <code>Iow</code> base class.
	 */
	public Iow24IoTest(IowFactory devs) {
		this.devs = devs;
	}

	/**
	 * Stand-alone start.
	 * @param args Not used here.
	 */	
	public static void main(String[] args) {
		Iow24IoTest iot = new Iow24IoTest();
		iot.doit();
		iot.devs.exit(0);	//never reached
	} 
	
	/**
	 * Thread start.
	 */	
	public void run() {
		doit();
	}

	/**
	 * Do all that work.
	 */
	private void doit() {
		int pause = 200;
		
		try {
			dev24 = devs.getIow24Device();
			dev24.setWriteTimeout(1000);
			
			dev24.setDirection(0, 0xf7); //all bits input, except bit 3 is output
					
			dev24.setPort(0, 0x00);	//all leds on
			dev24.writeIOPorts();
			Thread.sleep(pause);

			dev24.setPort(0, 0xff);
			dev24.writeIOPorts();
			Thread.sleep(pause);
			dev24.setPort(0, 0x00);
			dev24.writeIOPorts();
			Thread.sleep(pause);
			dev24.setPort(0, 0xff);
			dev24.writeIOPorts();
			Thread.sleep(pause);
			dev24.setPort(0, 0x00);
			dev24.writeIOPorts();
			Thread.sleep(pause);
			dev24.setPort(0, 0xff);
			dev24.writeIOPorts();
			Thread.sleep(pause);
			dev24.setPort(0, 0x00);
			dev24.writeIOPorts();
			Thread.sleep(pause);
			dev24.setPort(0, 0xff);
			dev24.writeIOPorts();
			Thread.sleep(pause);
			dev24.setPort(0, 0x00);
			dev24.writeIOPorts();
			Thread.sleep(pause);
			
			dev24.setPort(0, 0xff); //all leds off
			dev24.writeIOPorts();
			Thread.sleep(pause);

			dev24.setPort(0, 0xbf);
			dev24.writeIOPorts();
			System.out.println("OUT portChanged (index:0)," + dev24.getPort(0));

			dev24.autonomous(true);			
			System.out.println(dev24);
			dev24.getPort(0).addPortChangeListener(this);
			System.out.println(dev24);
			
			while(true) { //endless loop
				Thread.sleep(100000);
			}
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/*
	 * Port changed callback.
	 * @see de.wagner_ibw.iow.IowPortChangeListener#portChanged(de.wagner_ibw.iow.IowPort)
	 */
	public synchronized void portChanged(IowPort port) {
		//*deb*/System.out.println("\nIN  portChanged (index:" + port.getIndex() + ")," + port.toString());

		if (port.getIndex() == 0) {
			if (port.isBitClear(1)) {
				dev24.clearBit(0, 3);	//an
				//*deb*/System.out.println("OUT portChanged (index:0)," + dev24.getPort(0));
				System.out.println("P0.1 is clear");
				dev24.writeIOPorts();
			} else if (port.isBitClear(2)) {
				dev24.clearBit(0, 3);	//an
				//*deb*/System.out.println("OUT portChanged (index:0)," + dev24.getPort(0));
				System.out.println("P0.2 is clear");
				dev24.writeIOPorts();
			} else {
				//*deb*/System.out.println("OUT portChanged (index:0)," + dev24.getPort(0));
				System.out.println("P0.1,2 is set");
				dev24.setBit(0, 3);	//aus
				dev24.writeIOPorts();
			}
		}
	}	
}
