/*
 * This File is part of the iowj-project   
 * $Id: RfControlBatch.java,v 1.1 2006/03/12 19:13:27 Thomas Wagner Exp $
 * Copyright (C)2006 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.wagner_ibw.appl;

import java.util.NoSuchElementException;

import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowFactory;

/**
 * This simple application controls five consumer loads by rf remote control.
 * Uses <code>RFSwitch</code> as controller.
 * @see RFSwitch
 * @author Thomas Wagner
 */
public class RfControlBatch {

	private static String batch;
	private static char load;
	private static String action;
	private static IowFactory devs;
	private static AbstractIowDevice dev;
	
	private void init() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any plugged IO-Warrior device!");
			devs.exit(-1);
		}

		try {
			dev = devs.getIowDevice();
		} catch (NoSuchElementException e) {
			System.out.println("No IO-Warrior device found!");
			devs.exit(-1);
		}
	
		System.out.println(
			"Try to activate control batch on "
				+ dev.getName()
				+ ": switch "
				+ load
				+ " "
				+ action);
		
	}

	private static void usage(String msg) {
		System.out.println(msg);
		System.out.println(
			"Usage: java RfControlBatch <load> <action>");
		System.out.println(
			"  <load>   consumer load: A...E");
		System.out.println(
			"  <action> action: On | Off");
		System.out.println(
			"e.g. 'java RfControlBatch B On'");
	}

	public static void main(String[] args) {

		if (args.length != 2) {
			usage("Missing or too many arguments!");
			System.exit(-1);
		}

		load = args[0].toLowerCase().charAt(0);
		if (load < 'a' || load > 'e') {
			usage("Wrong argument <load> '" + args[0].charAt(0) + "'!");
			System.exit(-1);
		}


		action = args[1].toLowerCase();
		if ( !action.equals("on") && !action.equals("off")) {
			usage("Wrong argument <action> '" + args[1] + "'!");
			System.exit(-1);
		}
		
		RfControlBatch batch = new RfControlBatch();
		batch.init();
		
		RFSwitch rfs = new RFSwitch(dev);
		rfs.doSwitch(load,action);
		
		devs.exit(0);
	}
}
