/* 
 * This File is part of the iowj-project   
 * $Id: RFSwitch.java,v 1.1 2006/03/12 19:13:27 Thomas Wagner Exp $
 * Copyright (C)2006 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.wagner_ibw.appl;

import java.util.Date;

import de.wagner_ibw.iow.AbstractIowDevice;

/**
 * This simple application controls five consumer loads by rf remote control.
 * See <a href="http://www.wagner-ibw.de/rfctrl.html">here</a>.
 * @author Thomas Wagner
 */
public class RFSwitch {

	/**
	 * Defined control port of the IO-Warrior.
	 * See <a href="http://www.wagner-ibw.de/RfSwitch1.png">circuit</a>.  
	 */
	public static int PORT    = 1;
	
	/**
	 * Defined control bit of the IO-Warrior's port for load 'A'.
	 *  See <a href="http://www.wagner-ibw.de/RfSwitch1.png">circuit</a>.  
	 */
	public static int PIN_A   = 0;
	
	/**
	 * Defined control bit of the IO-Warrior's port for load 'B'.
	 *  See <a href="http://www.wagner-ibw.de/RfSwitch1.png">circuit</a>.  
	 */
	public static int PIN_B   = 1;
	
	/**
	 * Defined control bit of the IO-Warrior's port for load 'C'.
	 *  See <a href="http://www.wagner-ibw.de/RfSwitch1.png">circuit</a>.  
	 */
	public static int PIN_C   = 2;
	
	/**
	 * Defined control bit of the IO-Warrior's port for load 'D'.
	 *  See <a href="http://www.wagner-ibw.de/RfSwitch1.png">circuit</a>.  
	 */
	public static int PIN_D   = 5;
		
	/**
	 * Defined control bit of the IO-Warrior's port for command 'on'.
	 *  See <a href="http://www.wagner-ibw.de/RfSwitch1.png">circuit</a>.  
	 */	
	public static int PIN_ON  = 3;
	
	/**
	 * Defined control bit of the IO-Warrior's port for command 'off'.
	 *  See <a href="http://www.wagner-ibw.de/RfSwitch1.png">circuit</a>.  
	 */
	public static int PIN_OFF = 4;
		
	private AbstractIowDevice dev = null;
	
	/**
	 * Constructor.
	 * @param dev Underlying IO-Warrior device.
	 */
	public  RFSwitch(AbstractIowDevice dev) {
		this.dev = dev;
		
		dev.setDirection(PORT, 0x00);	//all bits output
		dev.setPort(PORT, 0xff); 		//all bits high
		dev.writeIOPorts();
	}
		
	/**
	 * Switch the load.
	 * @param load 
	 * @param action
	 */
	public void doSwitch(char load, String action) {
		int bit = 0;
		int op = 0;
		
		switch(load) {
			case('a'):
			case('A'):
				bit = PIN_A;
				break;
			case('b'):
			case('B'):
				bit = PIN_B;
				break;		
			case('c'):
			case('C'):
				bit = PIN_C;
				break;
			case('d'):
			case('D'):
				bit = PIN_D;
				break;
		}			
		
		if(action.toLowerCase().equals("on"))
			op = PIN_ON;
		else
			op = PIN_OFF;	
		
		Date date = new Date(System.currentTimeMillis());
		System.out.println("switch " + load + " " + action + " at " + date + " ...");
		
		dev.clearBit(PORT,bit);
		dev.clearBit(PORT,op);
		dev.writeIOPorts();
		try {
			Thread.sleep(300);
		} catch (Exception e) {
		}
		dev.setPort(PORT,0xff);
		dev.writeIOPorts();
	}
}
