/*
 * This File is part of the iowj-project   
 * $Id: IowBatch.java,v 1.5 2007/03/18 17:26:45 Thomas Wagner Exp $
 * Copyright (C)2005 by Thomas Wagner
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package de.wagner_ibw.appl;

import java.util.Date;
import java.util.NoSuchElementException;

import de.wagner_ibw.iow.AbstractIowDevice;
import de.wagner_ibw.iow.IowFactory;
import de.wagner_ibw.iow.IowPort;
import de.wagner_ibw.iow.IowPortChangeListener;

/**
 * This simple application starts an executable if the specified
 * bit on the specified port chages its state.
 * @author Thomas Wagner
 */
public class IowBatch implements IowPortChangeListener {

	private static String batch;
	private static int port;
	private static int bit;
	private static IowFactory devs;
	private static AbstractIowDevice dev;
	private static boolean state;

	private void init() {
		devs = IowFactory.getInstance();
		if (devs.getNumDevices() == 0) {
			System.out.println("Cannot find any plugged IO-Warrior device!");
			devs.exit(-1);
		}

		try {
			dev = devs.getIowDevice();
		} catch (NoSuchElementException e) {
			System.out.println("No IO-Warrior device found!");
			devs.exit(-1);
		}

		if (port > dev.getPortCount() - 1 || port < 0) {
			usage("Wrong argument <port> '" + port + "'!");
			System.exit(-1);
		}

		System.out.println(
			"Try to activate batch on "
				+ dev.getName()
				+ " P"
				+ port
				+ "."
				+ bit);

		try {
			dev.scanPorts();
			if (dev.getPort(port).isBitClear(bit)) {
				state = false;
			} else {
				state = true;
			}	
			dev.autonomous(true);
			dev.getPort(port).addPortChangeListener(this);

			System.out.println("Current Pin Status: " + state);
		} catch (Exception e) {
			System.out.println("Exception: " + e);
			devs.exit(-1);
		}
	}

	private static void usage(String msg) {
		System.out.println(msg);
		System.out.println(
			"Usage: java IowBatch <port> <bit> <cmd>");
		System.out.println(
			"  <port> scanned port of the IO-Warrior: 0...1 or 0...3");
		System.out.println(
			"  <bit>  scanned bit  of the IO-Warrior: 0...7");
		System.out.println(
			"  <cmd>  executable that will be executed if the pin status changes");
		System.out.println(
			"e.g. 'java IowBatch 0 1 notepad'");
	}

	public static void main(String[] args) {

		if (args.length != 3) {
			usage("Missing or too many arguments!");
			System.exit(-1);
		}

		try {
			port = Integer.parseInt(args[0]);
		} catch (NumberFormatException e) {
			usage("Wrong argument <port> '" + args[1] + "'!");
			System.exit(-1);
		}

		try {
			bit = Integer.parseInt(args[1]);
			if (bit > 7 || port < 0) {
				usage("Wrong argument <bit> '" + bit + "'!");
				System.exit(-1);
			}
		} catch (NumberFormatException e) {
			usage("Wrong argument <port> '" + args[2] + "'!");
			System.exit(-1);
		}

		batch = args[2];

		IowBatch batch = new IowBatch();
		batch.init();
	}

	/* (non-Javadoc)
	 * @see de.wagner_ibw.iow.IowPortChangeListener#portChanged(de.wagner_ibw.iow.IowPort)
	 */
	public void portChanged(IowPort cPort) {
		//*deb*/System.out.println("Port changes ...");
		if (cPort.getIndex() == port) {
			if (cPort.isBitSet(bit) != state) {
				Date date = new Date(System.currentTimeMillis());
				System.out.println(
					"Starting batch '" + batch + "' at " + date + " ...");
				try {
					Runtime.getRuntime().exec(batch);
				} catch (Exception e) {
					System.out.println(
						"Starting batch '" + batch + " failed! " + e);
					devs.exit(-1);
				}
			}
		}
	}
}
